/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ConstrainedForwardRecordIterator;
import db.ConvertedRecordIterator;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV3;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

class SymbolDatabaseAdapterV2
extends SymbolDatabaseAdapter {
    private static final int SYMBOL_VERSION = 2;
    private static final int V2_SYMBOL_NAME_COL = 0;
    private static final int V2_SYMBOL_ADDR_COL = 1;
    private static final int V2_SYMBOL_PARENT_ID_COL = 2;
    private static final int V2_SYMBOL_TYPE_COL = 3;
    private static final int V2_SYMBOL_DATA1_COL = 4;
    private static final int V2_SYMBOL_DATA2_COL = 5;
    private static final int V2_SYMBOL_DATA3_COL = 6;
    private static final int V2_SYMBOL_FLAGS_COL = 7;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV2(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap;
        this.symbolTable = handle.getTable("Symbols");
        if (this.symbolTable == null) {
            throw new VersionException("Missing Table: Symbols");
        }
        if (this.symbolTable.getSchema().getVersion() != 2) {
            int version = this.symbolTable.getSchema().getVersion();
            if (version < 2) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    DBRecord createSymbolRecord(String name, long namespaceID, Address address, SymbolType symbolType, boolean isPrimary, SourceType source) {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return false;
        }
        return this.symbolTable.hasRecord((Field)new LongField(key), 1);
    }

    @Override
    Field[] getSymbolIDs(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return Field.EMPTY_ARRAY;
        }
        return this.symbolTable.findRecords((Field)new LongField(key), 1);
    }

    @Override
    DBRecord getSymbolRecord(long symbolID) throws IOException {
        return this.convertV2Record(this.symbolTable.getRecord(symbolID));
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, forward));
        return new V2ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, startAddr, forward));
        return new V2ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    void updateSymbolRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return new V2ConvertedRecordIterator(this.symbolTable.iterator());
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, start, end, forward));
        return new V2ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    RecordIterator getSymbols(AddressSetView set, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward));
        return new V2ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    RecordIterator getPrimarySymbols(AddressSetView set, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward));
        return SymbolDatabaseAdapterV2.getPrimaryFilterRecordIterator((RecordIterator)new V2ConvertedRecordIterator((RecordIterator)it));
    }

    @Override
    DBRecord getPrimarySymbol(Address address) throws IOException {
        RecordIterator it = this.getPrimarySymbols(new AddressSet(address, address), true);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    private String getExternalStringData(DBRecord rec) {
        long addrKey = rec.getLongValue(1);
        Address addr = this.addrMap.decodeAddress(addrKey);
        if (addr == null || !addr.isExternalAddress()) {
            return null;
        }
        byte symbolTypeId = rec.getByteValue(3);
        if (symbolTypeId != SYMBOL_TYPE_FUNCTION && symbolTypeId != SYMBOL_TYPE_LABEL) {
            return null;
        }
        return rec.getString(6);
    }

    @Override
    RecordIterator getExternalSymbolsByMemoryAddress(Address extProgAddr) throws IOException {
        if (extProgAddr == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        String matchAddrStr = extProgAddr.toString();
        return new ConstrainedForwardRecordIterator(this.symbolTable.iterator(), rec -> {
            String str = this.getExternalStringData((DBRecord)rec);
            if (str != null) {
                String addressString;
                int indexOf = str.indexOf(",");
                String string = addressString = indexOf >= 0 ? str.substring(0, indexOf) : str;
                if (matchAddrStr.equals(addressString)) {
                    return this.convertV2Record((DBRecord)rec);
                }
            }
            return null;
        });
    }

    @Override
    RecordIterator getExternalSymbolsByOriginalImportName(String extLabel) throws IOException {
        return EmptyRecordIterator.INSTANCE;
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        LongField field = new LongField(id);
        RecordIterator it = this.symbolTable.indexIterator(2, (Field)field, (Field)field, true);
        return new V2ConvertedRecordIterator(it);
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField field = new StringField(name);
        RecordIterator it = this.symbolTable.indexIterator(0, (Field)field, (Field)field, true);
        return new V2ConvertedRecordIterator(it);
    }

    @Override
    RecordIterator scanSymbolsByName(String startName) throws IOException {
        StringField field = new StringField(startName);
        RecordIterator it = this.symbolTable.indexIterator(0, (Field)field, null, true);
        return new V2ConvertedRecordIterator(it);
    }

    @Override
    RecordIterator getSymbolsByNameAndNamespace(String name, long id) throws IOException {
        RecordIterator it = this.scanSymbolsByName(name);
        RecordIterator filtered = SymbolDatabaseAdapterV2.getNameAndNamespaceFilterIterator(name, id, it);
        return new V2ConvertedRecordIterator(filtered);
    }

    @Override
    DBRecord getSymbolRecord(Address address, String name, long id) throws IOException {
        RecordIterator it = this.scanSymbolsByName(name);
        long addressKey = this.addrMap.getKey(address, false);
        RecordIterator filtered = SymbolDatabaseAdapterV2.getNameNamespaceAddressFilterIterator(name, id, addressKey, it);
        if (filtered.hasNext()) {
            return filtered.next();
        }
        return null;
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        if (space.isMemorySpace()) {
            AddressIndexKeyIterator addressKeyIterator = new AddressIndexKeyIterator(this.symbolTable, 1, this.addrMap, space.getMinAddress(), space.getMaxAddress(), false);
            if (addressKeyIterator.hasNext()) {
                return this.addrMap.decodeAddress(addressKeyIterator.next());
            }
        } else {
            LongField val;
            Address addr;
            LongField max = new LongField(this.addrMap.getKey(space.getMaxAddress(), false));
            DBFieldIterator iterator = this.symbolTable.indexFieldIterator(null, (Field)max, false, 1);
            if (iterator.hasPrevious() && space.equals((addr = this.addrMap.decodeAddress((val = (LongField)iterator.previous()).getLongValue())).getAddressSpace())) {
                return addr;
            }
        }
        return null;
    }

    @Override
    Table getTable() {
        return this.symbolTable;
    }

    private DBRecord convertV2Record(DBRecord record) {
        if (record == null) {
            return null;
        }
        DBRecord rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(record.getKey());
        String symbolName = record.getString(0);
        rec.setString(0, symbolName);
        long symbolAddrKey = record.getLongValue(1);
        rec.setLongValue(1, symbolAddrKey);
        long namespaceId = record.getLongValue(2);
        rec.setLongValue(2, namespaceId);
        byte symbolTypeId = record.getByteValue(3);
        rec.setByteValue(3, symbolTypeId);
        rec.setByteValue(4, record.getByteValue(7));
        SymbolDatabaseAdapterV3.convertSymbolStringData(symbolTypeId, rec, record.getString(6));
        LongField hash = SymbolDatabaseAdapterV2.computeLocatorHash(symbolName, namespaceId, symbolAddrKey);
        rec.setField(5, (Field)hash);
        long dataTypeId = record.getLongValue(4);
        if (dataTypeId != -1L) {
            rec.setLongValue(7, dataTypeId);
        }
        SymbolType type = SymbolType.getSymbolType(symbolTypeId);
        int data2 = record.getIntValue(5);
        if (SymbolType.LABEL.equals(type)) {
            if (data2 == 1) {
                rec.setLongValue(6, symbolAddrKey);
            }
        } else if (SymbolType.PARAMETER.equals(type) || SymbolType.LOCAL_VAR.equals(type)) {
            rec.setIntValue(8, data2);
        }
        if (SymbolType.FUNCTION.equals(type)) {
            rec.setLongValue(6, symbolAddrKey);
        }
        return rec;
    }

    private class V2ConvertedRecordIterator
    extends ConvertedRecordIterator {
        V2ConvertedRecordIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected DBRecord convertRecord(DBRecord record) {
            return SymbolDatabaseAdapterV2.this.convertV2Record(record);
        }
    }
}

