/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeAttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.XRefFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableXRefFieldLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class VariableXRefFieldFactory
extends XRefFieldFactory {
    public static final String FIELD_NAME = "Variable XRef";

    public VariableXRefFieldFactory() {
        this(FIELD_NAME);
    }

    protected VariableXRefFieldFactory(String name) {
        super(name);
    }

    public VariableXRefFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        this(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    protected VariableXRefFieldFactory(String name, FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        super(name, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    protected void initDisplayOptions(Options displayOptions) {
        this.colorOptionName = "XRef Color";
        this.styleOptionName = "XRef Style";
        super.initDisplayOptions(displayOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        int count;
        Object obj = proxy.getObject();
        if (!this.enabled || obj == null || !(obj instanceof Variable)) {
            return null;
        }
        Variable var = (Variable)obj;
        ArrayList<Reference> xrefs = new ArrayList<Reference>();
        ArrayList<Reference> offcuts = new ArrayList<Reference>();
        XReferenceUtils.getVariableRefs(var, xrefs, offcuts, this.maxXRefs);
        if (xrefs.size() + offcuts.size() == 0) {
            return null;
        }
        Function func = var.getFunction();
        Program program = func.getProgram();
        this.displayLocalNamespace = false;
        this.displayBlockName = false;
        int totalXrefs = xrefs.size() + offcuts.size();
        boolean tooMany = totalXrefs > this.maxXRefs;
        AttributedString delimiter = new AttributedString(this.delim, (Color)GThemeDefaults.Colors.FOREGROUND, this.getMetrics());
        FieldElement[] elements = new FieldElement[tooMany ? this.maxXRefs : totalXrefs];
        for (count = 0; count < xrefs.size() && count < elements.length; ++count) {
            Reference reference = (Reference)xrefs.get(count);
            String prefix = this.getPrefix(program, reference, func);
            AttributedString as = new AttributedString(reference.getFromAddress().toString(prefix), (Color)ListingColors.XrefColors.DEFAULT, this.getMetrics());
            if (this.displayRefType) {
                as = this.createRefTypeAttributedString(reference, as);
            }
            if (count < totalXrefs - 1) {
                as = new CompositeAttributedString(new AttributedString[]{as, delimiter});
            } else {
                char[] charSpaces = new char[delimiter.length()];
                Arrays.fill(charSpaces, ' ');
                AttributedString spaces = new AttributedString(new String(charSpaces), (Color)ListingColors.XrefColors.DEFAULT, this.getMetrics());
                as = new CompositeAttributedString(new AttributedString[]{as, spaces});
            }
            elements[count] = new TextFieldElement(as, count, 0);
        }
        for (int i = 0; i < offcuts.size() && count < elements.length; ++i, ++count) {
            Reference ref = (Reference)offcuts.get(i);
            String prefix = this.getPrefix(program, ref, func);
            AttributedString as = new AttributedString(ref.getFromAddress().toString(prefix), (Color)ListingColors.XrefColors.OFFCUT, this.getMetrics());
            if (this.displayRefType) {
                as = this.createRefTypeAttributedString(ref, as);
            }
            if (count < totalXrefs - 1) {
                as = new CompositeAttributedString(new AttributedString[]{as, delimiter});
            } else {
                char[] charSpaces = new char[delimiter.length()];
                Arrays.fill(charSpaces, ' ');
                AttributedString spaces = new AttributedString(new String(charSpaces), (Color)ListingColors.XrefColors.OFFCUT, this.getMetrics());
                as = new CompositeAttributedString(new AttributedString[]{as, spaces});
            }
            elements[count] = new TextFieldElement(as, count, 0);
        }
        if (tooMany) {
            AttributedString as = new AttributedString("[more]", (Color)ListingColors.XrefColors.DEFAULT, this.getMetrics());
            elements[count - 1] = new TextFieldElement(as, count - 1, 0);
        }
        return ListingTextField.createPackedTextField(this, proxy, elements, this.startX + varWidth, this.width, this.maxXRefs, this.hlProvider);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Variable sv;
        VariableXRefFieldLocation varXRefLoc;
        if (!(loc instanceof VariableXRefFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Variable && (varXRefLoc = (VariableXRefFieldLocation)loc).isLocationFor(sv = (Variable)obj)) {
            return this.createFieldLocation(varXRefLoc.getCharOffset(), varXRefLoc.getIndex(), (ListingTextField)bf, index, fieldNum);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Variable)) {
            return null;
        }
        ListingTextField field = (ListingTextField)this.getField(bf.getProxy(), 0);
        if (field != null) {
            RowColLocation loc = field.screenToDataLocation(row, col);
            int index = loc.row();
            Variable var = (Variable)obj;
            ArrayList<Reference> xrefs = new ArrayList<Reference>();
            ArrayList<Reference> offcuts = new ArrayList<Reference>();
            XReferenceUtils.getVariableRefs(var, xrefs, offcuts, this.maxXRefs);
            Reference ref = null;
            if (index < xrefs.size()) {
                ref = (Reference)xrefs.get(index);
            } else if (index < xrefs.size() + offcuts.size()) {
                ref = (Reference)offcuts.get(index - xrefs.size());
            }
            if (ref != null) {
                Address refAddr = ref.getFromAddress();
                return new VariableXRefFieldLocation(var.getProgram(), var, refAddr, index, loc.col());
            }
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Variable.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 3;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions options, ToolOptions fieldOptions) {
        return new VariableXRefFieldFactory(formatModel, provider, (Options)options, fieldOptions);
    }
}

