/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.cmd.label.AddUniqueLabelCmd;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.ImportedSymbol;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class RelocLgByImport
extends Relocation {
    private int index;

    RelocLgByImport(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xFC00) >> 10;
        this.index = (value & 0x3FF) << 16;
        this.index |= reader.readNextShort();
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 41;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        Namespace tvectNamespace;
        LoaderInfoHeader loader = header.getLoader();
        ImportedLibrary library = loader.findLibrary(this.index);
        List<ImportedSymbol> importedSymbols = loader.getImportedSymbols();
        ImportedSymbol importedSymbol = importedSymbols.get(this.index);
        String name = SymbolUtilities.replaceInvalidChars((String)importedSymbol.getName(), (boolean)true);
        Address address = relocState.getRelocationAddress();
        AddUniqueLabelCmd cmd = new AddUniqueLabelCmd(address, name, tvectNamespace = importState.getTVectNamespace(), SourceType.IMPORTED);
        if (!cmd.applyTo(program)) {
            log.appendMsg(cmd.getStatusMsg());
        }
        Symbol symbol = importState.getSymbol(name, library);
        relocState.fixupMemory(address, symbol.getAddress(), log);
        relocState.incrementRelocationAddress(4);
        relocState.setImportIndex(this.index + 1);
    }
}

