/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Omf51LibraryHeaderRecord
extends OmfRecord {
    public static final int BLOCK_SIZE = 128;
    private short moduleCount;
    private short blockNumber;
    private short byteNumber;

    public Omf51LibraryHeaderRecord(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        this.moduleCount = this.dataReader.readNextShort();
        this.blockNumber = this.dataReader.readNextShort();
        this.byteNumber = this.dataReader.readNextShort();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        struct.add(WORD, "moduleCount", null);
        struct.add(WORD, "blockNumber", null);
        struct.add(WORD, "byteNumber", null);
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    public short getModuleCount() {
        return this.moduleCount;
    }

    public short getModNamesBlockNumber() {
        return this.blockNumber;
    }

    public short getModNamesByteNumber() {
        return this.byteNumber;
    }

    public int getModNamesOffset() {
        return this.blockNumber * 128 + this.byteNumber;
    }
}

