/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.exception;

import ghidra.util.exception.UsrException;

public class VersionException
extends UsrException {
    public static final int UNKNOWN_VERSION = 0;
    public static final int OLDER_VERSION = 1;
    public static final int NEWER_VERSION = 2;
    private boolean upgradeable = false;
    private int versionIndicator = 0;
    private String detailMessage = null;

    public VersionException() {
        this(false);
    }

    public VersionException(String msg) {
        super(msg);
    }

    public VersionException(boolean upgradable) {
        super(VersionException.getDefaultMessage(upgradable));
        this.upgradeable = upgradable;
        this.versionIndicator = upgradable ? 1 : 0;
    }

    public VersionException(int versionIndicator, boolean upgradable) {
        this(upgradable);
        this.versionIndicator = versionIndicator;
    }

    public VersionException(String msg, int versionIndicator, boolean upgradable) {
        this(msg);
        this.versionIndicator = versionIndicator;
        this.upgradeable = upgradable;
    }

    private static String getDefaultMessage(boolean upgradable) {
        if (upgradable) {
            return "data created with older software and requires upgrade";
        }
        return "data created with newer version and can not be read";
    }

    public boolean isUpgradable() {
        return this.upgradeable;
    }

    public int getVersionIndicator() {
        return this.versionIndicator;
    }

    public VersionException combine(VersionException ve) {
        if (ve != null) {
            if (this.versionIndicator != ve.versionIndicator) {
                this.versionIndicator = 0;
            }
            this.upgradeable &= ve.upgradeable;
            if (this.detailMessage == null) {
                this.detailMessage = ve.detailMessage;
            } else if (ve.detailMessage != null) {
                this.detailMessage = this.detailMessage + "\n" + ve.detailMessage;
            }
        }
        return this;
    }

    public void setDetailMessage(String message) {
        this.detailMessage = message;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }
}

