/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import com.google.common.base.Predicate;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.program.model.symbol.FlowType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;

class DNLEdgeLabelRenderer<V extends FGVertex, E extends FGEdge>
implements Renderer.EdgeLabel<V, E> {
    private static final int DEFAULT_EDGE_OFFSET = 20;
    private VisualGraphVertexShapeTransformer<V> vertexShapeTransformer = new VisualGraphVertexShapeTransformer();
    private double edgeOffset;

    DNLEdgeLabelRenderer(double condenseFactor) {
        this.edgeOffset = 20.0 * (1.0 - condenseFactor);
    }

    public void labelEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e, String text) {
        Graph jungGraph = layout.getGraph();
        if (!rc.getEdgeIncludePredicate().apply((Object)Context.getInstance((Object)jungGraph, e))) {
            return;
        }
        Pair endpoints = jungGraph.getEndpoints(e);
        FGVertex startv = (FGVertex)endpoints.getFirst();
        FGVertex endv = (FGVertex)endpoints.getSecond();
        Predicate includeVertex = rc.getVertexIncludePredicate();
        if (!includeVertex.apply((Object)Context.getInstance((Object)jungGraph, (Object)startv)) || !includeVertex.apply((Object)Context.getInstance((Object)jungGraph, (Object)endv))) {
            return;
        }
        Point2D start = (Point2D)layout.apply((Object)startv);
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        start = multiLayerTransformer.transform(Layer.LAYOUT, start);
        Shape vertexShape = this.vertexShapeTransformer.apply((VisualVertex)startv);
        Rectangle vertexBounds = vertexShape.getBounds();
        int xDisplacement = rc.getLabelOffset();
        Point2D.Double labelPointOffset = new Point2D.Double();
        double cx = start.getX();
        double cy = start.getY();
        EdgeLabelRenderer labelRenderer = rc.getEdgeLabelRenderer();
        Font font = (Font)rc.getEdgeFontTransformer().apply(e);
        boolean isSelected = rc.getPickedEdgeState().isPicked(e);
        Component component = labelRenderer.getEdgeLabelRendererComponent(rc.getScreenDevice(), (Object)text, font, isSelected, e);
        int labelWidth = component.getPreferredSize().width;
        List articulationPoints = e.getArticulationPoints();
        if (articulationPoints.isEmpty()) {
            double vertexBottom = start.getY() + (double)(vertexBounds.height >> 1);
            double textY = (int)(vertexBottom + this.edgeOffset);
            double textX = (int)(start.getX() + (double)xDisplacement);
            ((Point2D)labelPointOffset).setLocation(textX, textY);
        } else {
            boolean isRight;
            if (articulationPoints.size() == 1) {
                return;
            }
            Point2D bend1 = (Point2D)articulationPoints.get(0);
            bend1 = multiLayerTransformer.transform(Layer.LAYOUT, bend1);
            Point2D bend2 = (Point2D)articulationPoints.get(1);
            bend2 = multiLayerTransformer.transform(Layer.LAYOUT, bend2);
            double vertexSide = cx + (double)(vertexBounds.width >> 1);
            double vertexBottom = cy + (double)(vertexBounds.height >> 1);
            double bx1 = bend1.getX();
            FlowType flow = e.getFlowType();
            boolean bl = isRight = flow.isFallthrough() || flow.isUnConditional();
            if (articulationPoints.size() == 2) {
                double textX = (int)(vertexSide + this.edgeOffset);
                double textY = (int)(cy + this.edgeOffset);
                ((Point2D)labelPointOffset).setLocation(textX, textY);
            } else {
                double textY = (int)(vertexBottom + this.edgeOffset);
                double textX = (int)(bx1 + (double)xDisplacement);
                if (!isRight) {
                    textX = bx1 - (double)xDisplacement - (double)labelWidth;
                }
                ((Point2D)labelPointOffset).setLocation(textX, textY);
            }
        }
        Dimension d = component.getPreferredSize();
        GraphicsDecorator g = rc.getGraphicsContext();
        AffineTransform old = g.getTransform();
        AffineTransform xform = new AffineTransform(old);
        xform.translate(((Point2D)labelPointOffset).getX(), ((Point2D)labelPointOffset).getY());
        g.setTransform(xform);
        g.draw(component, rc.getRendererPane(), 0, 0, d.width, d.height, true);
        g.setTransform(old);
    }

    private void labelArticulations(Component component, GraphicsDecorator g, RenderContext<V, E> rc, E e) {
        int offset = 5;
        int counter = 1;
        List points = e.getArticulationPoints();
        for (Point2D p : points) {
            MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
            p = multiLayerTransformer.transform(Layer.LAYOUT, p);
            EdgeLabelRenderer labelRenderer = rc.getEdgeLabelRenderer();
            Font font = (Font)rc.getEdgeFontTransformer().apply(e);
            boolean isSelected = rc.getPickedEdgeState().isPicked(e);
            component = labelRenderer.getEdgeLabelRendererComponent(rc.getScreenDevice(), (Object)("p" + counter++), font, isSelected, e);
            Dimension d = component.getPreferredSize();
            AffineTransform old = g.getTransform();
            AffineTransform xform = new AffineTransform(old);
            xform.translate(p.getX() + (double)offset, p.getY());
            g.setTransform(xform);
            g.draw(component, rc.getRendererPane(), 0, 0, d.width, d.height, true);
            g.setTransform(old);
        }
    }
}

