/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.RemoveUserInfo;
import io.cucumber.cienvironment.VariableExpression;
import io.cucumber.cienvironment.internal.com.eclipsesource.json.Json;
import io.cucumber.cienvironment.internal.com.eclipsesource.json.JsonValue;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class CiEnvironmentImpl
implements CiEnvironment {
    public String name;
    public String url;
    public String buildNumber;
    public Git git;

    CiEnvironmentImpl() {
    }

    CiEnvironmentImpl(String name, String url, String buildNumber, Git git) {
        this.name = Objects.requireNonNull(name);
        this.url = Objects.requireNonNull(url);
        this.buildNumber = buildNumber;
        this.git = git;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(this.buildNumber);
    }

    @Override
    public Optional<CiEnvironment.Git> getGit() {
        return Optional.ofNullable(this.git);
    }

    Optional<CiEnvironment> detect(Map<String, String> env) {
        String url = VariableExpression.evaluate(this.getUrl(), env);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new CiEnvironmentImpl(this.name, url, VariableExpression.evaluate(this.getBuildNumber().orElse(null), env), this.detectGit(env)));
    }

    private Git detectGit(Map<String, String> env) {
        String revision = this.evaluateRevision(env);
        if (revision == null) {
            return null;
        }
        String remote = VariableExpression.evaluate(this.git.remote, env);
        if (remote == null) {
            return null;
        }
        return new Git(RemoveUserInfo.fromUrl(remote), revision, VariableExpression.evaluate(this.git.branch, env), VariableExpression.evaluate(this.git.tag, env));
    }

    private String evaluateRevision(Map<String, String> env) {
        if ("pull_request".equals(env.get("GITHUB_EVENT_NAME"))) {
            if (env.get("GITHUB_EVENT_PATH") == null) {
                throw new RuntimeException("GITHUB_EVENT_PATH not set");
            }
            try {
                JsonValue event = Json.parse(new InputStreamReader((InputStream)new FileInputStream(env.get("GITHUB_EVENT_PATH")), StandardCharsets.UTF_8));
                return event.asObject().get("pull_request").asObject().get("head").asObject().get("sha").asString();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read .pull_request.head.sha from " + env.get("GITHUB_EVENT_PATH"), e);
            }
        }
        return VariableExpression.evaluate(this.git.revision, env);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CiEnvironmentImpl that = (CiEnvironmentImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.git, that.git);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.buildNumber, this.git);
    }

    public String toString() {
        return "CiEnvironmentImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", buildNumber='" + this.buildNumber + '\'' + ", git=" + this.git + '}';
    }

    static final class Git
    implements CiEnvironment.Git {
        public String remote;
        public String revision;
        public String branch;
        public String tag;

        Git() {
        }

        Git(String remote, String revision, String branch, String tag) {
            this.remote = Objects.requireNonNull(remote);
            this.revision = Objects.requireNonNull(revision);
            this.branch = branch;
            this.tag = tag;
        }

        @Override
        public String getRemote() {
            return this.remote;
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Git git = (Git)o;
            return Objects.equals(this.remote, git.remote) && Objects.equals(this.revision, git.revision) && Objects.equals(this.branch, git.branch) && Objects.equals(this.tag, git.tag);
        }

        public int hashCode() {
            return Objects.hash(this.remote, this.revision, this.branch, this.tag);
        }

        public String toString() {
            return "Git{remote='" + this.remote + '\'' + ", revision='" + this.revision + '\'' + ", branch='" + this.branch + '\'' + ", tag='" + this.tag + '\'' + '}';
        }
    }
}

