/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflate;
import java.io.UnsupportedEncodingException;

public class GZIPHeader
implements Cloneable {
    public static final byte OS_MSDOS = 0;
    public static final byte OS_AMIGA = 1;
    public static final byte OS_VMS = 2;
    public static final byte OS_UNIX = 3;
    public static final byte OS_ATARI = 5;
    public static final byte OS_OS2 = 6;
    public static final byte OS_MACOS = 7;
    public static final byte OS_TOPS20 = 10;
    public static final byte OS_WIN32 = 11;
    public static final byte OS_VMCMS = 4;
    public static final byte OS_ZSYSTEM = 8;
    public static final byte OS_CPM = 9;
    public static final byte OS_QDOS = 12;
    public static final byte OS_RISCOS = 13;
    public static final byte OS_UNKNOWN = -1;
    boolean text = false;
    private boolean fhcrc = false;
    long time;
    int xflags;
    int os = 255;
    byte[] extra;
    byte[] name;
    byte[] comment;
    int hcrc;
    long crc;
    boolean done = false;
    long mtime = 0L;

    public void setModifiedTime(long l) {
        this.mtime = l;
    }

    public long getModifiedTime() {
        return this.mtime;
    }

    public void setOS(int n) {
        if ((0 > n || n > 13) && n != 255) {
            throw new IllegalArgumentException("os: " + n);
        }
        this.os = n;
    }

    public int getOS() {
        return this.os;
    }

    public void setName(String string) {
        try {
            this.name = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("name must be in ISO-8859-1 " + string);
        }
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        try {
            return new String(this.name, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public void setComment(String string) {
        try {
            this.comment = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("comment must be in ISO-8859-1 " + this.name);
        }
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        try {
            return new String(this.comment, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public void setCRC(long l) {
        this.crc = l;
    }

    public long getCRC() {
        return this.crc;
    }

    void put(Deflate deflate) {
        int n = 0;
        if (this.text) {
            n |= 1;
        }
        if (this.fhcrc) {
            n |= 2;
        }
        if (this.extra != null) {
            n |= 4;
        }
        if (this.name != null) {
            n |= 8;
        }
        if (this.comment != null) {
            n |= 0x10;
        }
        int n2 = 0;
        if (deflate.level == 1) {
            n2 |= 4;
        } else if (deflate.level == 9) {
            n2 |= 2;
        }
        deflate.put_short(-29921);
        deflate.put_byte((byte)8);
        deflate.put_byte((byte)n);
        deflate.put_byte((byte)this.mtime);
        deflate.put_byte((byte)(this.mtime >> 8));
        deflate.put_byte((byte)(this.mtime >> 16));
        deflate.put_byte((byte)(this.mtime >> 24));
        deflate.put_byte((byte)n2);
        deflate.put_byte((byte)this.os);
        if (this.extra != null) {
            deflate.put_byte((byte)this.extra.length);
            deflate.put_byte((byte)(this.extra.length >> 8));
            deflate.put_byte(this.extra, 0, this.extra.length);
        }
        if (this.name != null) {
            deflate.put_byte(this.name, 0, this.name.length);
            deflate.put_byte((byte)0);
        }
        if (this.comment != null) {
            deflate.put_byte(this.comment, 0, this.comment.length);
            deflate.put_byte((byte)0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        byte[] byArray;
        GZIPHeader gZIPHeader = (GZIPHeader)super.clone();
        if (gZIPHeader.extra != null) {
            byArray = new byte[gZIPHeader.extra.length];
            System.arraycopy(gZIPHeader.extra, 0, byArray, 0, byArray.length);
            gZIPHeader.extra = byArray;
        }
        if (gZIPHeader.name != null) {
            byArray = new byte[gZIPHeader.name.length];
            System.arraycopy(gZIPHeader.name, 0, byArray, 0, byArray.length);
            gZIPHeader.name = byArray;
        }
        if (gZIPHeader.comment != null) {
            byArray = new byte[gZIPHeader.comment.length];
            System.arraycopy(gZIPHeader.comment, 0, byArray, 0, byArray.length);
            gZIPHeader.comment = byArray;
        }
        return gZIPHeader;
    }
}

