import { select } from '@inquirer/prompts';
import yaml from 'js-yaml';
import fs from 'node:fs';
import { SwapChoice } from '../classes/krill_enums.js';
export default async function selectUserSwapChoice(initialSwapChoice = SwapChoice.Small) {
    let partitions = {};
    if (fs.existsSync('/etc/calamares/modules/partition.conf')) {
        partitions = yaml.load(fs.readFileSync('/etc/calamares/modules/partition.conf', 'utf8'));
    }
    else {
        partitions.userSwapChoices = Object.values(SwapChoice);
        partitions.initialSwapChoice = initialSwapChoice;
    }
    const choices = partitions.userSwapChoices.map((c) => ({ name: c, value: c }));
    const answer = await select({
        message: 'Select the swap choice',
        choices,
        default: partitions.initialSwapChoice,
    });
    return answer;
}
