/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import oracle.net.aso.AsoException;
import oracle.net.aso.EncryptionAlgorithm;

class RC4
implements EncryptionAlgorithm {
    private static final byte NAEREN_RENEWAL_KEY_PAD = 123;
    private static final byte DATA_INTEGRITY_RENEWAL_KEY_PAD = -1;
    private static final int NAEREN_SERVER_TO_CLIENT_KEY_PAD = 170;
    private static final int NAEREN_CLIENT_TO_SERVER_KEY_PAD = 85;
    private static final int DATA_INTEGRITY_SERVER_TO_CLIENT_KEY_PAD = 180;
    private static final int DATA_INTEGRITY_CLIENT_TO_SERVER_KEY_PAD = 90;
    private static final byte[] fixed = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private RC4Algorithm rc4Session;
    private RC4Algorithm rc4Outgoing;
    private RC4Algorithm rc4Incoming;
    private boolean oraclePadding = true;
    private boolean dataIntegrityMode = false;
    private int rc4KeySize = 40;
    private boolean allowWeakCrypto = true;
    private byte[] originalDHKey = null;

    RC4(int key_size) throws AsoException {
        switch (key_size) {
            case 40: 
            case 56: 
            case 128: 
            case 256: {
                this.rc4KeySize = key_size;
                break;
            }
            default: {
                throw new AsoException(100);
            }
        }
    }

    RC4(byte[] key, byte[] iv, boolean allowWeakCrypto) {
        this.allowWeakCrypto = allowWeakCrypto;
        this.rc4KeySize = allowWeakCrypto ? 40 : 128;
        this.dataIntegrityMode = true;
        this.oraclePadding = false;
        try {
            this.init(key, iv);
        }
        catch (AsoException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(byte[] key, byte[] iv) throws AsoException {
        this.rc4Session = new RC4JCEWrapper();
        this.rc4Outgoing = new RC4JCEWrapper();
        this.rc4Incoming = new RC4JCEWrapper();
        this.setSessionKey(key, iv);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        byte[] result;
        if (this.oraclePadding) {
            result = new byte[ciphertext.length - 1];
            this.rc4Incoming.encrypt(result, ciphertext, ciphertext.length - 1);
        } else {
            result = new byte[ciphertext.length];
            this.rc4Incoming.encrypt(result, ciphertext, ciphertext.length);
        }
        return result;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        byte[] result;
        if (this.oraclePadding) {
            result = new byte[plaintext.length + 1];
            this.rc4Outgoing.encrypt(result, plaintext, plaintext.length);
            result[plaintext.length] = 0;
        } else {
            result = new byte[plaintext.length];
            this.rc4Outgoing.encrypt(result, plaintext, plaintext.length);
        }
        return result;
    }

    @Override
    public String getProviderName() {
        if (this.rc4Outgoing != null) {
            return this.rc4Outgoing.getProviderName();
        }
        return null;
    }

    @Override
    public int maxDelta() {
        return 1;
    }

    @Override
    public void setSessionKey(byte[] dhKey, byte[] iv) throws AsoException {
        int paddingByte;
        int keyLength;
        if (dhKey == null && iv == null) {
            this.renewKey();
            return;
        }
        if (this.allowWeakCrypto) {
            if (this.originalDHKey == null) {
                this.originalDHKey = (byte[])dhKey.clone();
            } else {
                dhKey = this.originalDHKey;
            }
        }
        if (dhKey.length < (keyLength = this.rc4KeySize / 8)) {
            throw new AsoException(102);
        }
        byte[] workspace = null;
        int n = paddingByte = this.dataIntegrityMode ? -1 : 123;
        if (!this.dataIntegrityMode || this.allowWeakCrypto) {
            int ivLength = iv == null ? 0 : iv.length;
            workspace = new byte[keyLength + 1 + ivLength];
            System.arraycopy(dhKey, dhKey.length - keyLength, workspace, 0, keyLength);
            workspace[keyLength] = paddingByte;
            if (iv != null) {
                System.arraycopy(iv, 0, workspace, keyLength + 1, iv.length);
            }
        } else {
            workspace = new byte[keyLength + 32];
            System.arraycopy(dhKey, 0, workspace, 0, keyLength);
            workspace[keyLength - 1] = paddingByte;
            System.arraycopy(dhKey, 32, workspace, keyLength, 32);
        }
        this.rc4Session.init(1, workspace, workspace.length);
        this.renewKey();
    }

    @Override
    public void renewKey() throws AsoException {
        int keyLength = this.rc4KeySize / 8;
        if (!this.dataIntegrityMode) {
            byte[] workspace = new byte[keyLength];
            this.rc4Session.encrypt(workspace, fixed, keyLength);
            if (this.oraclePadding) {
                int n = keyLength - 1;
                workspace[n] = (byte)(workspace[n] ^ 0xAA);
            }
            this.rc4Incoming.init(2, workspace, keyLength);
            int n = keyLength - 1;
            workspace[n] = (byte)(workspace[n] ^ 0xAA);
            this.rc4Outgoing.init(1, workspace, keyLength);
        } else {
            byte[] workspace = this.allowWeakCrypto ? new byte[keyLength + 1] : new byte[keyLength];
            this.rc4Session.encrypt(workspace, fixed, keyLength);
            workspace[workspace.length - 1] = -76;
            this.rc4Incoming.init(2, workspace, workspace.length);
            workspace[workspace.length - 1] = 90;
            this.rc4Outgoing.init(1, workspace, workspace.length);
        }
    }

    private class RC4JCEWrapper
    implements RC4Algorithm {
        private Cipher rc4Cipher;

        private RC4JCEWrapper() {
        }

        @Override
        public void init(int mode, byte[] key_data, int key_size) {
            try {
                this.rc4Cipher = Cipher.getInstance("RC4");
                SecretKeySpec keySpec = new SecretKeySpec(key_data, "RC4");
                this.rc4Cipher.init(mode, keySpec);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void encrypt(byte[] output, byte[] input, int input_size) {
            try {
                this.rc4Cipher.update(input, 0, input_size, output);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getProviderName() {
            if (this.rc4Cipher != null) {
                return this.rc4Cipher.getProvider().getName();
            }
            return null;
        }
    }

    static interface RC4Algorithm {
        public void init(int var1, byte[] var2, int var3);

        public void encrypt(byte[] var1, byte[] var2, int var3);

        public String getProviderName();
    }
}

