/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.Frozen;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNodeReader;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;

public final class LoadingConfiguration
implements Frozen<LoadingConfigurationBuilder> {
    final Map<String, URIDownloader> downloaders;
    final URITranslatorConfiguration translatorCfg;
    final int cacheSize;
    final Dereferencing dereferencing;
    final Map<URI, JsonNode> preloadedSchemas;
    final EnumSet<JsonParser.Feature> parserFeatures;
    private final JsonNodeReader reader;

    public static LoadingConfigurationBuilder newBuilder() {
        return new LoadingConfigurationBuilder();
    }

    public static LoadingConfiguration byDefault() {
        return new LoadingConfigurationBuilder().freeze();
    }

    LoadingConfiguration(LoadingConfigurationBuilder builder) {
        this.downloaders = builder.downloaders.build();
        this.translatorCfg = builder.translatorCfg;
        this.dereferencing = builder.dereferencing;
        this.preloadedSchemas = ImmutableMap.copyOf(builder.preloadedSchemas);
        this.parserFeatures = EnumSet.copyOf(builder.parserFeatures);
        this.reader = this.buildReader();
        this.cacheSize = builder.cacheSize;
    }

    private JsonNodeReader buildReader() {
        ObjectMapper mapper = JacksonUtils.newMapper();
        for (JsonParser.Feature feature : this.parserFeatures) {
            mapper.configure(feature, true);
        }
        return new JsonNodeReader(mapper);
    }

    public Map<String, URIDownloader> getDownloaderMap() {
        return this.downloaders;
    }

    public URITranslatorConfiguration getTranslatorConfiguration() {
        return this.translatorCfg;
    }

    public Dereferencing getDereferencing() {
        return this.dereferencing;
    }

    public Map<URI, JsonNode> getPreloadedSchemas() {
        return this.preloadedSchemas;
    }

    public JsonNodeReader getReader() {
        return this.reader;
    }

    @Deprecated
    public boolean getEnableCache() {
        return this.cacheSize != 0;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public LoadingConfigurationBuilder thaw() {
        return new LoadingConfigurationBuilder(this);
    }
}

