/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.flags;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.wildfly.common.Assert;

public abstract class Flags<E extends Enum<E>, This extends Flags<E, This>>
extends AbstractSet<E>
implements SortedSet<E> {
    final int bits;

    protected Flags(int bits) {
        this.bits = bits;
    }

    protected abstract This value(int var1);

    protected abstract This this_();

    protected abstract E itemOf(int var1);

    protected abstract E castItemOrNull(Object var1);

    protected abstract This castThis(Object var1);

    @Override
    public final int size() {
        return Integer.bitCount(this.bits);
    }

    @Override
    public final E first() {
        int bits = this.bits;
        if (bits == 0) {
            throw new NoSuchElementException();
        }
        return this.itemOf(Integer.numberOfTrailingZeros(Integer.lowestOneBit(bits)));
    }

    @Override
    public final E last() {
        int bits = this.bits;
        if (bits == 0) {
            throw new NoSuchElementException();
        }
        return this.itemOf(Integer.numberOfTrailingZeros(Integer.highestOneBit(bits)));
    }

    @Override
    public final Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.bits == 0;
    }

    public final This headSet(E toElement) {
        Assert.checkNotNullParam("toElement", toElement);
        return this.value(this.bits & Flags.bitOf(toElement) - 1);
    }

    public final This tailSet(E fromElement) {
        Assert.checkNotNullParam("fromElement", fromElement);
        return this.value(this.bits & ~(Flags.bitOf(fromElement) - 1));
    }

    public final This subSet(E fromElement, E toElement) {
        Assert.checkNotNullParam("fromElement", fromElement);
        Assert.checkNotNullParam("toElement", toElement);
        return this.value(this.bits & Flags.bitOf(toElement) - 1 & ~(Flags.bitOf(fromElement) - 1));
    }

    @Override
    public final Object[] toArray() {
        int b = this.bits;
        Object[] array = new Object[Integer.bitCount(b)];
        int idx = 0;
        while (Integer.bitCount(b) > 0) {
            int lob = Integer.lowestOneBit(b);
            array[idx + 1] = this.itemOf(Integer.numberOfTrailingZeros(lob));
            b ^= lob;
        }
        return array;
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        int b = this.bits;
        int size = Integer.bitCount(b);
        if (size > array.length) {
            array = Arrays.copyOf(array, size);
        }
        int idx = 0;
        while (Integer.bitCount(b) > 0) {
            int lob = Integer.lowestOneBit(b);
            array[idx + 1] = this.itemOf(Integer.numberOfTrailingZeros(lob));
            b ^= lob;
        }
        return array;
    }

    @Override
    public final boolean contains(E flag) {
        return flag != null && (this.bits & Flags.bitOf(flag)) != 0;
    }

    @Override
    public final boolean contains(Object o) {
        return this.contains(this.castItemOrNull(o));
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        if (c.getClass() == this.getClass()) {
            return this.containsAll(this.castThis(c));
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(This other) {
        int otherBits = ((Flags)other).bits;
        return (this.bits & otherBits) == otherBits;
    }

    public final boolean containsAll(E flag1, E flag2) {
        return this.contains(flag1) && this.contains(flag2);
    }

    public final boolean containsAll(E flag1, E flag2, E flag3) {
        return this.containsAll(flag1, flag2) && this.contains(flag3);
    }

    public final boolean containsAny(This other) {
        return other != null && (this.bits & ((Flags)other).bits) != 0;
    }

    public final boolean containsAny(E flag1, E flag2) {
        return this.contains(flag1) || this.contains(flag2);
    }

    public final boolean containsAny(E flag1, E flag2, E flag3) {
        return this.containsAny(flag1, flag2) || this.contains(flag3);
    }

    public final This complement() {
        return this.value(~this.bits);
    }

    public final This with(E flag) {
        return flag == null ? this.this_() : this.value(this.bits | Flags.bitOf(flag));
    }

    public final This with(E flag1, E flag2) {
        return ((Flags)this.with((This)flag1)).with((This)flag2);
    }

    public final This with(E flag1, E flag2, E flag3) {
        return ((Flags)this.with(flag1, flag2)).with((This)flag3);
    }

    @SafeVarargs
    public final This with(E ... flags) {
        if (flags == null) {
            return this.this_();
        }
        int b = this.bits;
        for (E flag : flags) {
            if (flag == null) continue;
            b |= Flags.bitOf(flag);
        }
        return this.value(b);
    }

    public final This with(This other) {
        return other == null ? this.this_() : this.value(this.bits | ((Flags)other).bits);
    }

    public final This without(E flag) {
        return flag == null ? this.this_() : this.value(this.bits & ~Flags.bitOf(flag));
    }

    public final This without(This other) {
        return other == null ? this.this_() : this.value(this.bits & ~((Flags)other).bits);
    }

    @Override
    public final boolean equals(Object o) {
        return o == this || o instanceof Set && this.equals((This)((Set)o));
    }

    public final boolean equals(Set<?> o) {
        return o == this || o.containsAll(this) && this.containsAll((This)o);
    }

    @Override
    public final boolean equals(This o) {
        return o == this;
    }

    @Override
    public final int hashCode() {
        int lob;
        int hc = 0;
        for (int b = this.bits; b != 0; b ^= lob) {
            lob = Integer.lowestOneBit(b);
            hc += ((Enum)this.itemOf(Integer.numberOfTrailingZeros(lob))).hashCode();
        }
        return hc;
    }

    @Override
    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            int b;
            {
                this.b = Flags.this.bits;
            }

            @Override
            public boolean hasNext() {
                return this.b != 0;
            }

            @Override
            public E next() {
                int b = this.b;
                if (b == 0) {
                    throw new NoSuchElementException();
                }
                int lob = Integer.lowestOneBit(b);
                Object item = Flags.this.itemOf(Integer.numberOfTrailingZeros(lob));
                this.b = b ^ lob;
                return item;
            }
        };
    }

    public final Iterator<E> descendingIterator() {
        return new Iterator<E>(){
            int b;
            {
                this.b = Flags.this.bits;
            }

            @Override
            public boolean hasNext() {
                return this.b != 0;
            }

            @Override
            public E next() {
                int b = this.b;
                if (b == 0) {
                    throw new NoSuchElementException();
                }
                int hob = Integer.highestOneBit(b);
                Object item = Flags.this.itemOf(Integer.numberOfTrailingZeros(hob));
                this.b = b ^ hob;
                return item;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int lob;
        Assert.checkNotNullParam("action", action);
        for (int b = this.bits; b != 0; b ^= lob) {
            lob = Integer.lowestOneBit(b);
            action.accept(this.itemOf(Integer.numberOfTrailingZeros(lob)));
        }
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append('[');
        int bits = this.bits;
        if (bits != 0) {
            int lob = Integer.lowestOneBit(bits);
            buf.append(this.itemOf(Integer.numberOfTrailingZeros(lob)));
            bits ^= lob;
            while (bits != 0) {
                buf.append(' ');
                lob = Integer.lowestOneBit(bits);
                buf.append(this.itemOf(Integer.numberOfTrailingZeros(lob)));
                bits ^= lob;
            }
        }
        buf.append(']');
        return buf.toString();
    }

    private static int bitOf(Enum<?> item) {
        return 1 << item.ordinal();
    }
}

