/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStepProvider;

public abstract class RoleBasedStepProvider
implements WorkflowStepProvider {
    private final Logger log = Logger.getLogger(RoleBasedStepProvider.class);
    public static final String CONFIG_ROLE = "role";
    private final KeycloakSession session;
    private final ComponentModel model;

    public RoleBasedStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.model = model;
    }

    public void run(WorkflowExecutionContext context) {
        UserModel user = this.session.users().getUserById(this.getRealm(), context.getResourceId());
        if (user != null) {
            try {
                this.getRoles().forEach(role -> this.run(user, (RoleModel)role));
            }
            catch (Exception e) {
                this.log.errorf((Throwable)e, "Failed to grant role to user %s", (Object)user.getId());
            }
        }
    }

    protected abstract void run(UserModel var1, RoleModel var2);

    public void close() {
    }

    private Stream<RoleModel> getRoles() {
        return ((List)this.model.getConfig().getOrDefault((Object)CONFIG_ROLE, List.of())).stream().map(this::getRole);
    }

    private RoleModel getRole(String name) {
        RoleModel role;
        String[] parts = name.split("/");
        if (parts.length > 1) {
            ClientModel client = this.getRealm().getClientByClientId(parts[0]);
            if (client == null) {
                throw new IllegalStateException("Client with clientId " + parts[0] + " not found");
            }
            role = client.getRole(parts[1]);
        } else {
            role = this.getRealm().getRole(name);
        }
        if (role == null) {
            throw new IllegalStateException("Role " + name + " not found");
        }
        return role;
    }

    private RealmModel getRealm() {
        return this.session.getContext().getRealm();
    }
}

