/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.exporter.otlp;

import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.opentelemetry.deployment.exporter.otlp.ExternalOtelExporterBuildItem;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.build.exporter.OtlpExporterBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterConfigBuilder;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OTelExporterRecorder;
import io.quarkus.opentelemetry.runtime.exporter.otlp.tracing.LateBoundSpanProcessor;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.deployment.spi.TlsRegistryBuildItem;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

@BuildSteps
public class OtlpExporterProcessor {
    private static final DotName METRIC_EXPORTER = DotName.createSimple((String)MetricExporter.class.getName());
    private static final DotName LOG_RECORD_EXPORTER = DotName.createSimple((String)LogRecordExporter.class.getName());
    private static final DotName OKHTTP_INTERCEPTOR = DotName.createSimple((String)"okhttp3.Interceptor");

    @BuildStep
    void logging(BuildProducer<LogCategoryBuildItem> log) {
        log.produce((BuildItem)new LogCategoryBuildItem("io.opentelemetry.exporter.internal.grpc.GrpcExporter", Level.OFF));
        log.produce((BuildItem)new LogCategoryBuildItem("io.opentelemetry.exporter.internal.http.HttpExporter", Level.OFF));
    }

    @BuildStep
    void config(BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilderProducer) {
        runTimeConfigBuilderProducer.produce((BuildItem)new RunTimeConfigBuilderBuildItem(OtlpExporterConfigBuilder.class));
    }

    @BuildStep(onlyIf={OtlpUpstreamExporterEnabled.class})
    void errorIfOtlpUpstreamIsUsed(CombinedIndexBuildItem indexBuildItem, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ClassInfo okHttpInterceptor = indexBuildItem.getIndex().getClassByName(OKHTTP_INTERCEPTOR);
        if (okHttpInterceptor == null) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException("OpenTelemetry exporter set to 'otlp' but upstream dependencies not found. Please notice: The Quarkus default exporters are already OTLP protocol compliant. For more see: https://quarkus.io/guides/opentelemetry#default-2")}));
        }
    }

    @BuildStep(onlyIf={OtlpTracingExporterEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=TlsRegistryBuildItem.class)
    void createSpanProcessor(OTelExporterRecorder recorder, CoreVertxBuildItem vertxBuildItem, List<ExternalOtelExporterBuildItem> externalOtelExporterBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (!externalOtelExporterBuildItem.isEmpty()) {
            return;
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(LateBoundSpanProcessor.class).types(new Class[]{SpanProcessor.class})).setRuntimeInit().scope(Singleton.class)).unremovable()).addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)SpanExporter.class.getName()))}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TlsConfigurationRegistry.class)), new AnnotationInstance[0])).createWith(recorder.spanProcessorForOtlp(vertxBuildItem.getVertx())).done());
    }

    @BuildStep(onlyIf={OtlpMetricsExporterEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=TlsRegistryBuildItem.class)
    void createMetricsExporterProcessor(BeanDiscoveryFinishedBuildItem beanDiscovery, OTelExporterRecorder recorder, List<ExternalOtelExporterBuildItem> externalOtelExporterBuildItem, CoreVertxBuildItem vertxBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (!externalOtelExporterBuildItem.isEmpty()) {
            return;
        }
        if (!beanDiscovery.beanStream().withBeanType(METRIC_EXPORTER).isEmpty()) {
            return;
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MetricExporter.class).types(new Class[]{MetricExporter.class})).setRuntimeInit().scope(Singleton.class)).unremovable()).addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)MetricExporter.class.getName()))}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TlsConfigurationRegistry.class)), new AnnotationInstance[0])).createWith(recorder.createMetricExporter(vertxBuildItem.getVertx())).done());
    }

    @BuildStep(onlyIf={OtlpLogRecordExporterEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=TlsRegistryBuildItem.class)
    void createLogRecordExporterProcessor(BeanDiscoveryFinishedBuildItem beanDiscovery, OTelExporterRecorder recorder, List<ExternalOtelExporterBuildItem> externalOtelExporterBuildItem, CoreVertxBuildItem vertxBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (!externalOtelExporterBuildItem.isEmpty()) {
            return;
        }
        if (!beanDiscovery.beanStream().withBeanType(LOG_RECORD_EXPORTER).isEmpty()) {
            return;
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(LogRecordExporter.class).types(new Class[]{LogRecordExporter.class})).setRuntimeInit().scope(Singleton.class)).unremovable()).addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)LogRecordExporter.class.getName()))}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TlsConfigurationRegistry.class)), new AnnotationInstance[0])).createWith(recorder.createLogRecordExporter(vertxBuildItem.getVertx())).done());
    }

    static class OtlpUpstreamExporterEnabled
    implements BooleanSupplier {
        OtlpExporterBuildConfig exportBuildConfig;
        OTelBuildConfig otelBuildConfig;

        OtlpUpstreamExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.enabled() && this.exportBuildConfig.enabled() && (this.isLogsOtlp(this.otelBuildConfig) || this.isMetricsOtlp(this.otelBuildConfig) || this.isTracesOtlp(this.otelBuildConfig));
        }

        private boolean isLogsOtlp(OTelBuildConfig otelBuildConfig) {
            return otelBuildConfig.logs().enabled().orElse(Boolean.TRUE) != false && otelBuildConfig.logs().exporter().contains("otlp");
        }

        private boolean isMetricsOtlp(OTelBuildConfig otelBuildConfig) {
            return otelBuildConfig.metrics().enabled().orElse(Boolean.TRUE) != false && otelBuildConfig.metrics().exporter().contains("otlp");
        }

        private boolean isTracesOtlp(OTelBuildConfig otelBuildConfig) {
            return otelBuildConfig.traces().enabled().orElse(Boolean.TRUE) != false && otelBuildConfig.traces().exporter().contains("otlp");
        }
    }

    static class OtlpLogRecordExporterEnabled
    implements BooleanSupplier {
        OtlpExporterBuildConfig exportBuildConfig;
        OTelBuildConfig otelBuildConfig;

        OtlpLogRecordExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.enabled() && this.otelBuildConfig.logs().enabled().orElse(Boolean.TRUE) != false && this.otelBuildConfig.logs().exporter().contains("cdi") && this.exportBuildConfig.enabled();
        }
    }

    static class OtlpMetricsExporterEnabled
    implements BooleanSupplier {
        OtlpExporterBuildConfig exportBuildConfig;
        OTelBuildConfig otelBuildConfig;

        OtlpMetricsExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.enabled() && this.otelBuildConfig.metrics().enabled().orElse(Boolean.TRUE) != false && this.otelBuildConfig.metrics().exporter().contains("cdi") && this.exportBuildConfig.enabled();
        }
    }

    static class OtlpTracingExporterEnabled
    implements BooleanSupplier {
        OtlpExporterBuildConfig exportBuildConfig;
        OTelBuildConfig otelBuildConfig;

        OtlpTracingExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.enabled() && this.otelBuildConfig.traces().enabled().orElse(Boolean.TRUE) != false && this.otelBuildConfig.traces().exporter().contains("cdi") && this.exportBuildConfig.enabled();
        }
    }
}

