/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J,\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u0010H\u0007J<\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u0010H\u0007J,\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u0010H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenConsumerPomUtil;", "", "<init>", "()V", "isAutomaticVersionFeatureEnabled", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/util/xml/ConvertContext;", "getAutomaticParentVersion", "", "getDerivedPropertiesForConsumerPom", "extractor", "Lkotlin/Function1;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/util/xml/GenericDomValue;", "getDerivedParentPropertyForConsumerPom", "currentPomFile", "Lcom/intellij/psi/xml/XmlFile;", "parentElementArtifactId", "parentElementGroupId", "getParentPomPropertyUsingRelativePath", "getMavenParentElementFromContext", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "intellij.maven"})
public final class MavenConsumerPomUtil {
    @NotNull
    public static final MavenConsumerPomUtil INSTANCE = new MavenConsumerPomUtil();

    private MavenConsumerPomUtil() {
    }

    @JvmStatic
    public static final boolean isAutomaticVersionFeatureEnabled(@Nullable VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MavenDomUtil.isAtLeastMaven4(file2, project);
    }

    @JvmStatic
    public static final boolean isAutomaticVersionFeatureEnabled(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile = context2.getFile().getVirtualFile();
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(virtualFile, project);
    }

    @JvmStatic
    @Nullable
    public static final String getAutomaticParentVersion(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return MavenConsumerPomUtil.getDerivedPropertiesForConsumerPom(context2, (Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>>)((Function1)MavenConsumerPomUtil::getAutomaticParentVersion$lambda$0));
    }

    @JvmStatic
    @Nullable
    public static final String getDerivedPropertiesForConsumerPom(@NotNull ConvertContext context2, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        MavenDomParent mavenDomParent = INSTANCE.getMavenParentElementFromContext(context2);
        if (mavenDomParent == null) {
            return null;
        }
        MavenDomParent parentElement = mavenDomParent;
        String artifactId = (String)parentElement.getArtifactId().getValue();
        String groupId = (String)parentElement.getGroupId().getValue();
        if (artifactId == null || groupId == null) {
            return null;
        }
        XmlFile xmlFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        return MavenConsumerPomUtil.getDerivedParentPropertyForConsumerPom(xmlFile, artifactId, groupId, extractor);
    }

    @JvmStatic
    @Nullable
    public static final String getDerivedParentPropertyForConsumerPom(@NotNull XmlFile currentPomFile, @NotNull String parentElementArtifactId, @NotNull String parentElementGroupId, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        String parentRealGroupId;
        Intrinsics.checkNotNullParameter((Object)currentPomFile, (String)"currentPomFile");
        Intrinsics.checkNotNullParameter((Object)parentElementArtifactId, (String)"parentElementArtifactId");
        Intrinsics.checkNotNullParameter((Object)parentElementGroupId, (String)"parentElementGroupId");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        PsiDirectory psiDirectory = currentPomFile.getParent();
        PsiFile psiFile = psiDirectory != null && (psiDirectory = psiDirectory.getParent()) != null ? psiDirectory.findFile("pom.xml") : null;
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile parentPsi = xmlFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel((PsiFile)parentPsi, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return null;
        }
        MavenDomProjectModel mavenParentDomPsiModel = mavenDomProjectModel;
        String string = (String)mavenParentDomPsiModel.getGroupId().getValue();
        if (string == null) {
            string = parentRealGroupId = (String)mavenParentDomPsiModel.getMavenParent().getGroupId().getValue();
        }
        if (Intrinsics.areEqual((Object)mavenParentDomPsiModel.getArtifactId().getValue(), (Object)parentElementArtifactId) && Intrinsics.areEqual((Object)parentRealGroupId, (Object)parentElementGroupId)) {
            return (String)((GenericDomValue)extractor.invoke((Object)mavenParentDomPsiModel)).getValue();
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final String getParentPomPropertyUsingRelativePath(@NotNull ConvertContext context2, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        MavenDomParent mavenDomParent = INSTANCE.getMavenParentElementFromContext(context2);
        if (mavenDomParent == null) {
            return null;
        }
        MavenDomParent parent = mavenDomParent;
        PsiFile psiFile = (PsiFile)parent.getRelativePath().getValue();
        if (psiFile == null) {
            return null;
        }
        PsiFile parentPom = psiFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel(parentPom, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return null;
        }
        MavenDomProjectModel parentPomDomModel = mavenDomProjectModel;
        return (String)((GenericDomValue)extractor.invoke((Object)parentPomDomModel)).getValue();
    }

    private final MavenDomParent getMavenParentElementFromContext(ConvertContext context2) {
        MavenDomParent mavenDomParent;
        DomElement domElement = context2.getInvocationElement().getParent();
        MavenDomParent mavenDomParent2 = mavenDomParent = domElement instanceof MavenDomParent ? (MavenDomParent)domElement : null;
        if (mavenDomParent != null) {
            return mavenDomParent;
        }
        DomElement domElement2 = context2.getInvocationElement().getParent();
        MavenDomProjectModel mavenDomProjectModel = domElement2 instanceof MavenDomProjectModel ? (MavenDomProjectModel)domElement2 : null;
        return mavenDomProjectModel != null ? mavenDomProjectModel.getMavenParent() : null;
    }

    private static final GenericDomValue getAutomaticParentVersion$lambda$0(MavenDomProjectModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GenericDomValue<String> genericDomValue = it.getVersion();
        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"getVersion(...)");
        return genericDomValue;
    }
}

