/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.StrippedIntOpenHashMap;
import com.intellij.util.ArrayUtil;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MostlyUShortIntList
implements IntUnaryOperator {
    private static final int IN_MAP = 65535;
    private char[] myData;
    private int mySize;
    private StrippedIntOpenHashMap myMap;

    public MostlyUShortIntList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void add(int value) {
        if (value < 0 || value >= 65535) {
            this.initMap().put(this.mySize, value);
            value = 65535;
        }
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = (char)value;
    }

    void set(int index, int value) {
        if (value < 0 || value >= 65535) {
            this.initMap().put(index, value);
            value = 65535;
        }
        this.myData[index] = (char)value;
    }

    private StrippedIntOpenHashMap initMap() {
        if (this.myMap == null) {
            this.myMap = new StrippedIntOpenHashMap();
        }
        return this.myMap;
    }

    @Override
    public int applyAsInt(int index) {
        return this.get(index);
    }

    public int get(int index) {
        int value = this.myData[index];
        return value == 65535 ? this.myMap.get(index, 0) : value;
    }

    int size() {
        return this.mySize;
    }

    void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }
}

