/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex;

import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

public class GradleSourceSetArtifactIndex {
    @NotNull
    private final ModelBuilderContext myContext;
    @NotNull
    private final ConcurrentMap<ProjectIdentifier, Boolean> myProjectProcessingStatus;
    @NotNull
    private final ConcurrentMap<String, SourceSet> mySourceSetArtifactMap;
    @NotNull
    private final ConcurrentMap<String, String> mySourceSetOutputArtifactMap;
    @NotNull
    private final ConcurrentMap<String, Set<File>> mySourceMap;
    @NotNull
    private static final ModelBuilderContext.DataProvider<GradleSourceSetArtifactIndex> INSTANCE_PROVIDER = GradleSourceSetArtifactIndex::new;

    private GradleSourceSetArtifactIndex(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myProjectProcessingStatus = new ConcurrentHashMap<ProjectIdentifier, Boolean>();
        this.mySourceSetArtifactMap = new ConcurrentHashMap<String, SourceSet>();
        this.mySourceSetOutputArtifactMap = new ConcurrentHashMap<String, String>();
        this.mySourceMap = new ConcurrentHashMap<String, Set<File>>();
    }

    @NotNull
    public Set<File> findArtifactSources(@NotNull Collection<? extends File> artifactFiles) {
        if (artifactFiles == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(1);
        }
        LinkedHashSet<File> artifactSources = new LinkedHashSet<File>();
        for (File file : artifactFiles) {
            artifactSources.addAll(this.findSourcesByArtifact(file.getPath()));
        }
        LinkedHashSet<File> linkedHashSet = artifactSources;
        if (linkedHashSet == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<File> findArtifactSources(@NotNull File artifactFile) {
        if (artifactFile == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(3);
        }
        return this.findSourcesByArtifact(artifactFile.getPath());
    }

    @NotNull
    private Set<File> findSourcesByArtifact(@NotNull String path) {
        if (path == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(4);
        }
        Set set = this.mySourceMap.computeIfAbsent(path, it -> {
            SourceSet sourceSet = (SourceSet)this.mySourceSetArtifactMap.get(it);
            if (sourceSet == null) {
                return Collections.emptySet();
            }
            return sourceSet.getAllJava().getSrcDirs();
        });
        if (set == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public SourceSet findByArtifact(@NotNull String artifactPath) {
        if (artifactPath == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(6);
        }
        return (SourceSet)this.mySourceSetArtifactMap.get(artifactPath);
    }

    @Nullable
    public String findArtifactBySourceSetOutputDir(@NotNull String outputPath) {
        if (outputPath == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(7);
        }
        return (String)this.mySourceSetOutputArtifactMap.get(outputPath);
    }

    public void setSourceSetArtifactModel(@NotNull Project project, @NotNull GradleSourceSetArtifactModel model) {
        ProjectIdentifier projectIdentifier;
        Boolean projectProcessingStatus;
        if (project == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(8);
        }
        if (model == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(9);
        }
        if ((projectProcessingStatus = this.myProjectProcessingStatus.put(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project), true)) != null) {
            this.myContext.getMessageReporter().createMessage().withGroup("gradle.sourceSetArtifactIndex.cacheSet.group").withTitle("Source set artifact index model redefinition").withText("Source set artifact index model for " + project.getDisplayName() + " was already collected.").withInternal().withStackTrace().withKind(Message.Kind.ERROR).reportMessage(project);
        }
        this.mySourceSetArtifactMap.putAll(model.getSourceSetArtifactMap());
        this.mySourceSetOutputArtifactMap.putAll(model.getSourceSetOutputArtifactMap());
    }

    public void markSourceSetArtifactModelAsError(@NotNull Project project) {
        if (project == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(10);
        }
        ProjectIdentifier projectIdentifier = GradleProjectUtil.getProjectIdentifier(project);
        this.myProjectProcessingStatus.put(projectIdentifier, false);
    }

    @NotNull
    public static GradleSourceSetArtifactIndex getInstance(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(11);
        }
        GradleSourceSetArtifactIndex gradleSourceSetArtifactIndex = (GradleSourceSetArtifactIndex)context.getData(INSTANCE_PROVIDER);
        if (gradleSourceSetArtifactIndex == null) {
            GradleSourceSetArtifactIndex.$$$reportNull$$$0(12);
        }
        return gradleSourceSetArtifactIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFiles";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetArtifactIndex/GradleSourceSetArtifactIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetArtifactIndex/GradleSourceSetArtifactIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifactSources";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourcesByArtifact";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactSources";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSourcesByArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findByArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactBySourceSetOutputDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSourceSetArtifactModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markSourceSetArtifactModelAsError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

