/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error.future;

import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldHaveFailedWithin
extends BasicErrorMessageFactory {
    private static final String SHOULD_HAVE_FAILED_WITHIN_DURATION = "%nExpecting%n  <%s>%nto have failed within %s.%nBe aware that the state of the future in this message might not reflect the one at the time when the assertion was performed as it is evaluated later on";
    private static final String SHOULD_HAVE_FAILED_WITHIN = "%nExpecting%n  <%s>%nto have failed within %s %s.%nBe aware that the state of the future in this message might not reflect the one at the time when the assertion was performed as it is evaluated later on";

    public static ErrorMessageFactory shouldHaveFailedWithin(Future<?> actual, Duration timeout) {
        return new ShouldHaveFailedWithin(actual, timeout);
    }

    public static ErrorMessageFactory shouldHaveFailedWithin(Future<?> actual, long timeout, TimeUnit unit) {
        return new ShouldHaveFailedWithin(actual, timeout, unit);
    }

    private ShouldHaveFailedWithin(Future<?> actual, Duration timeout) {
        super(SHOULD_HAVE_FAILED_WITHIN_DURATION, actual, timeout);
    }

    private ShouldHaveFailedWithin(Future<?> actual, long timeout, TimeUnit unit) {
        super(SHOULD_HAVE_FAILED_WITHIN, new Object[]{actual, timeout, unit});
    }
}

