/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.outline.MapAwareOutlinePane;
import org.freeplane.view.swing.map.outline.NodeButton;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;
import org.freeplane.view.swing.ui.NodeSelector;

class TimeDelayedOutlineSelection
implements ActionListener {
    static final NodeSelector outlineSelector = new NodeSelector(TimeDelayedOutlineSelection::new, TimeDelayedOutlineSelection::findMapView);
    private final MouseEvent mouseEvent;

    private static MapView findMapView(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        MapAwareOutlinePane pane = (MapAwareOutlinePane)SwingUtilities.getAncestorOfClass(MapAwareOutlinePane.class, component);
        if (pane == null) {
            return null;
        }
        return pane.getCurrentMapView();
    }

    TimeDelayedOutlineSelection(MouseEvent e) {
        this.mouseEvent = e;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TreeNode node;
        if (this.mouseEvent.getModifiers() != 0) {
            return;
        }
        Component component = this.mouseEvent.getComponent();
        MapAwareOutlinePane pane = (MapAwareOutlinePane)SwingUtilities.getAncestorOfClass(MapAwareOutlinePane.class, component);
        if (pane == null) {
            return;
        }
        ScrollableTreePanel treePanel = pane.getTreePanel();
        if (component instanceof NodeButton) {
            NodeButton button = (NodeButton)component;
            node = button.getNode();
        } else {
            node = treePanel.getOutlineSelection().getSelectedNode();
        }
        if (node.getLevel() == 0 || node.getParent() != null) {
            treePanel.setSelectedNode(node, true);
        }
    }
}

