/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.TomcatPrincipal;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.jaspic.MessageInfoImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.filters.CorsFilter;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.FilterUtil;
import org.apache.catalina.util.SessionIdGeneratorBase;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.res.StringManager;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
RegistrationListener {
    private final Log log = LogFactory.getLog(AuthenticatorBase.class);
    private static final String DATE_ONE = FastHttpDateFormat.formatDate((long)1L);
    protected static final StringManager sm = StringManager.getManager(AuthenticatorBase.class);
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String REALM_NAME = "Authentication required";
    protected boolean alwaysUseSession = false;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;
    protected Context context = null;
    protected boolean disableProxyCaching = true;
    protected boolean securePagesWithPragma = false;
    protected String secureRandomClass = null;
    protected String secureRandomAlgorithm = SessionIdGeneratorBase.DEFAULT_SECURE_RANDOM_ALGORITHM;
    protected String secureRandomProvider = null;
    protected String jaspicCallbackHandlerClass = "org.apache.catalina.authenticator.jaspic.CallbackHandlerImpl";
    protected boolean sendAuthInfoResponseHeaders = false;
    protected SessionIdGeneratorBase sessionIdGenerator = null;
    protected SingleSignOn sso = null;
    private AllowCorsPreflight allowCorsPreflight = AllowCorsPreflight.NEVER;
    private volatile String jaspicAppContextID = null;
    private volatile Optional<AuthConfigProvider> jaspicProvider = null;
    private volatile CallbackHandler jaspicCallbackHandler = null;

    protected static String getRealmName(Context context) {
        if (context == null) {
            return REALM_NAME;
        }
        LoginConfig loginConfig = context.getLoginConfig();
        if (loginConfig == null) {
            return REALM_NAME;
        }
        String string = loginConfig.getRealmName();
        if (string == null) {
            return REALM_NAME;
        }
        return string;
    }

    public AuthenticatorBase() {
        super(true);
    }

    public String getAllowCorsPreflight() {
        return this.allowCorsPreflight.name().toLowerCase(Locale.ENGLISH);
    }

    public void setAllowCorsPreflight(String string) {
        this.allowCorsPreflight = AllowCorsPreflight.valueOf(string.trim().toUpperCase(Locale.ENGLISH));
    }

    public boolean getAlwaysUseSession() {
        return this.alwaysUseSession;
    }

    public void setAlwaysUseSession(boolean bl) {
        this.alwaysUseSession = bl;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    @Override
    public Container getContainer() {
        return this.context;
    }

    @Override
    public void setContainer(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean bl) {
        this.disableProxyCaching = bl;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean bl) {
        this.securePagesWithPragma = bl;
    }

    public boolean getChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean bl) {
        this.changeSessionIdOnAuthentication = bl;
    }

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String string) {
        this.secureRandomClass = string;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String string) {
        this.secureRandomAlgorithm = string;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String string) {
        this.secureRandomProvider = string;
    }

    public String getJaspicCallbackHandlerClass() {
        return this.jaspicCallbackHandlerClass;
    }

    public void setJaspicCallbackHandlerClass(String string) {
        this.jaspicCallbackHandlerClass = string;
    }

    public boolean isSendAuthInfoResponseHeaders() {
        return this.sendAuthInfoResponseHeaders;
    }

    public void setSendAuthInfoResponseHeaders(boolean bl) {
        this.sendAuthInfoResponseHeaders = bl;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object object;
        Principal principal;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Security checking request " + request.getMethod() + " " + request.getRequestURI()));
        }
        if (this.cache && (principal = request.getUserPrincipal()) == null && (object = request.getSessionInternal(false)) != null && (principal = object.getPrincipal()) != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("We have cached auth type " + object.getAuthType() + " for principal " + String.valueOf(principal)));
            }
            request.setAuthType(object.getAuthType());
            request.setUserPrincipal(principal);
        }
        boolean bl = this.isContinuationRequired(request);
        object = this.context.getRealm();
        SecurityConstraint[] securityConstraintArray = object.findSecurityConstraints(request, this.context);
        AuthConfigProvider authConfigProvider = this.getJaspicProvider();
        if (authConfigProvider != null) {
            bl = true;
        }
        if (securityConstraintArray == null && !this.context.getPreemptiveAuthentication() && !bl) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Not subject to any constraint");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (securityConstraintArray != null && this.disableProxyCaching && !"POST".equals(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Expires", DATE_ONE);
            } else {
                response.setHeader("Cache-Control", "private");
            }
        }
        if (securityConstraintArray != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Calling hasUserDataPermission()");
            }
            if (!object.hasUserDataPermission(request, response, securityConstraintArray)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("authenticator.userDataPermissionFail"));
                }
                return;
            }
        }
        boolean bl2 = false;
        if (securityConstraintArray != null) {
            bl2 = true;
            for (int i = 0; i < securityConstraintArray.length && bl2; ++i) {
                String[] stringArray;
                if (!securityConstraintArray[i].getAuthConstraint()) {
                    bl2 = false;
                    continue;
                }
                if (securityConstraintArray[i].getAllRoles() || securityConstraintArray[i].getAuthenticatedUsers() || (stringArray = securityConstraintArray[i].findAuthRoles()) != null && stringArray.length != 0) continue;
                bl2 = false;
            }
        }
        if (!bl && bl2) {
            bl = true;
        }
        if (!bl && this.context.getPreemptiveAuthentication() && this.isPreemptiveAuthPossible(request)) {
            bl = true;
        }
        JaspicState jaspicState = null;
        if ((bl || securityConstraintArray != null) && this.allowCorsPreflightBypass(request)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.corsBypass"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (bl) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Calling authenticate()");
            }
            if (authConfigProvider != null && (jaspicState = this.getJaspicState(authConfigProvider, request, response, bl2)) == null) {
                return;
            }
            if (authConfigProvider == null && !this.doAuthenticate(request, response) || authConfigProvider != null && !this.authenticateJaspic(request, response, jaspicState, false)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("authenticator.authenticationFail"));
                }
                return;
            }
        }
        if (securityConstraintArray != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Calling accessControl()");
            }
            if (!object.hasResourcePermission(request, response, securityConstraintArray, this.context)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("authenticator.userPermissionFail", new Object[]{request.getUserPrincipal().getName()}));
                }
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
        if (authConfigProvider != null) {
            this.secureResponseJspic(request, response, jaspicState);
        }
    }

    protected boolean allowCorsPreflightBypass(Request request) {
        String string;
        String string2;
        boolean bl = false;
        if (this.allowCorsPreflight != AllowCorsPreflight.NEVER && "OPTIONS".equals(request.getMethod()) && (string2 = request.getHeader("Origin")) != null && !string2.isEmpty() && RequestUtil.isValidOrigin((String)string2) && !RequestUtil.isSameOrigin((HttpServletRequest)request, (String)string2) && (string = request.getHeader("Access-Control-Request-Method")) != null && !string.isEmpty()) {
            if (this.allowCorsPreflight == AllowCorsPreflight.ALWAYS) {
                bl = true;
            } else if (this.allowCorsPreflight == AllowCorsPreflight.FILTER && DispatcherType.REQUEST == request.getDispatcherType()) {
                block0: for (FilterDef filterDef : request.getContext().findFilterDefs()) {
                    if (!CorsFilter.class.getName().equals(filterDef.getFilterClass())) continue;
                    for (FilterMap filterMap : this.context.findFilterMaps()) {
                        String string3;
                        if (!filterMap.getFilterName().equals(filterDef.getFilterName())) continue;
                        if ((filterMap.getDispatcherMapping() & 8) <= 0 || !FilterUtil.matchFiltersURL(filterMap, string3 = FilterUtil.getRequestPath((ServletRequest)request))) break block0;
                        bl = true;
                        break block0;
                    }
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        AuthConfigProvider authConfigProvider = this.getJaspicProvider();
        if (authConfigProvider == null) {
            return this.doAuthenticate(request, httpServletResponse);
        }
        Response response = request.getResponse();
        JaspicState jaspicState = this.getJaspicState(authConfigProvider, request, response, true);
        if (jaspicState == null) {
            return false;
        }
        boolean bl = this.authenticateJaspic(request, response, jaspicState, true);
        this.secureResponseJspic(request, response, jaspicState);
        return bl;
    }

    private void secureResponseJspic(Request request, Response response, JaspicState jaspicState) {
        try {
            jaspicState.serverAuthContext.secureResponse(jaspicState.messageInfo, null);
            request.setRequest((HttpServletRequest)jaspicState.messageInfo.getRequestMessage());
            response.setResponse((HttpServletResponse)jaspicState.messageInfo.getResponseMessage());
        }
        catch (AuthException authException) {
            this.log.warn((Object)sm.getString("authenticator.jaspicSecureResponseFail"), (Throwable)authException);
        }
    }

    private JaspicState getJaspicState(AuthConfigProvider authConfigProvider, Request request, Response response, boolean bl) throws IOException {
        JaspicState jaspicState = new JaspicState();
        jaspicState.messageInfo = new MessageInfoImpl(request.getRequest(), response.getResponse(), bl);
        try {
            CallbackHandler callbackHandler = this.getCallbackHandler();
            ServerAuthConfig serverAuthConfig = authConfigProvider.getServerAuthConfig("HttpServlet", this.jaspicAppContextID, callbackHandler);
            String string = serverAuthConfig.getAuthContextID(jaspicState.messageInfo);
            jaspicState.serverAuthContext = serverAuthConfig.getAuthContext(string, null, null);
        }
        catch (AuthException authException) {
            this.log.warn((Object)sm.getString("authenticator.jaspicServerAuthContextFail"), (Throwable)authException);
            response.sendError(500);
            return null;
        }
        return jaspicState;
    }

    private CallbackHandler getCallbackHandler() {
        CallbackHandler callbackHandler = this.jaspicCallbackHandler;
        if (callbackHandler == null) {
            callbackHandler = this.createCallbackHandler();
        }
        return callbackHandler;
    }

    private CallbackHandler createCallbackHandler() {
        CallbackHandler callbackHandler;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.jaspicCallbackHandlerClass, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(this.jaspicCallbackHandlerClass);
            }
            callbackHandler = (CallbackHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new SecurityException(reflectiveOperationException);
        }
        if (callbackHandler instanceof Contained) {
            ((Contained)((Object)callbackHandler)).setContainer(this.getContainer());
        }
        this.jaspicCallbackHandler = callbackHandler;
        return callbackHandler;
    }

    protected abstract boolean doAuthenticate(Request var1, HttpServletResponse var2) throws IOException;

    protected boolean isContinuationRequired(Request request) {
        return false;
    }

    protected void associate(String string, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(string, session);
    }

    private boolean authenticateJaspic(Request request, Response response, JaspicState jaspicState, boolean bl) {
        AuthStatus authStatus;
        boolean bl2 = this.checkForCachedAuthentication(request, response, false);
        Subject subject = new Subject();
        try {
            authStatus = jaspicState.serverAuthContext.validateRequest(jaspicState.messageInfo, subject, null);
        }
        catch (AuthException authException) {
            this.log.debug((Object)sm.getString("authenticator.loginFail"), (Throwable)authException);
            response.setStatus(500);
            return false;
        }
        request.setRequest((HttpServletRequest)jaspicState.messageInfo.getRequestMessage());
        response.setResponse((HttpServletResponse)jaspicState.messageInfo.getResponseMessage());
        if (authStatus == AuthStatus.SUCCESS) {
            GenericPrincipal genericPrincipal = this.getPrincipal(subject);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Authenticated user: " + String.valueOf(genericPrincipal)));
            }
            if (genericPrincipal == null) {
                request.setUserPrincipal(null);
                request.setAuthType(null);
                if (bl) {
                    return false;
                }
            } else if (!bl2 || !genericPrincipal.getUserPrincipal().equals(request.getUserPrincipal())) {
                String string;
                Boolean bl3 = null;
                String string2 = "JASPIC";
                Map map = jaspicState.messageInfo.getMap();
                String string3 = (String)map.get("jakarta.servlet.http.registerSession");
                if (string3 != null) {
                    bl3 = Boolean.valueOf(string3);
                }
                if ((string = (String)map.get("jakarta.servlet.http.authType")) != null) {
                    string2 = string;
                }
                if (bl3 != null) {
                    this.register(request, response, genericPrincipal, string2, null, null, this.alwaysUseSession || bl3 != false, bl3);
                } else {
                    this.register(request, response, genericPrincipal, string2, null, null);
                }
            }
            request.setNote("org.apache.catalina.authenticator.jaspic.SUBJECT", subject);
            return true;
        }
        return false;
    }

    private GenericPrincipal getPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<GenericPrincipal> set = subject.getPrivateCredentials(GenericPrincipal.class);
        if (set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    protected boolean checkForCachedAuthentication(Request request, HttpServletResponse httpServletResponse, boolean bl) {
        String string;
        Principal principal = request.getUserPrincipal();
        String string2 = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.check.found", new Object[]{principal.getName()}));
            }
            if (string2 != null) {
                this.associate(string2, request.getSessionInternal(true));
            }
            return true;
        }
        if (bl && string2 != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.check.sso", new Object[]{string2}));
            }
            if (this.reauthenticateFromSSO(string2, request)) {
                return true;
            }
        }
        if (request.getCoyoteRequest().getRemoteUserNeedsAuthorization() && (string = request.getCoyoteRequest().getRemoteUser().toString()) != null) {
            String string3;
            Principal principal2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.check.authorize", new Object[]{string}));
            }
            if ((principal2 = this.context.getRealm().authenticate(string)) == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("authenticator.check.authorizeFail", new Object[]{string}));
                }
                principal2 = new GenericPrincipal(string);
            }
            if ((string3 = request.getAuthType()) == null || string3.isEmpty()) {
                string3 = this.getAuthMethod();
            }
            this.register(request, httpServletResponse, principal2, string3, string, null);
            return true;
        }
        return false;
    }

    protected boolean reauthenticateFromSSO(String string, Request request) {
        Realm realm;
        if (this.sso == null || string == null) {
            return false;
        }
        boolean bl = false;
        Container container = this.getContainer();
        if (container != null && (realm = container.getRealm()) != null) {
            bl = this.sso.reauthenticate(string, realm, request);
        }
        if (bl) {
            this.associate(string, request.getSessionInternal(true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.reauthentication", new Object[]{request.getUserPrincipal().getName(), request.getAuthType()}));
            }
        }
        return bl;
    }

    public void register(Request request, HttpServletResponse httpServletResponse, Principal principal, String string, String string2, String string3) {
        this.register(request, httpServletResponse, principal, string, string2, string3, this.alwaysUseSession, this.cache);
    }

    protected void register(Request request, HttpServletResponse httpServletResponse, Principal principal, String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        Object object;
        if (this.log.isDebugEnabled()) {
            object = principal == null ? "none" : principal.getName();
            this.log.debug((Object)sm.getString("authenticator.authentication", new Object[]{object, string}));
        }
        request.setAuthType(string);
        request.setUserPrincipal(principal);
        if (this.sendAuthInfoResponseHeaders && Boolean.TRUE.equals(request.getAttribute("org.apache.tomcat.request.forwarded"))) {
            httpServletResponse.setHeader("remote-user", request.getRemoteUser());
            httpServletResponse.setHeader("auth-type", request.getAuthType());
        }
        if ((object = request.getSessionInternal(false)) != null) {
            if (this.getChangeSessionIdOnAuthentication() && principal != null) {
                string4 = this.changeSessionID(request, (Session)object);
                if (object.getNote("org.apache.catalina.authenticator.SESSION_ID") != null) {
                    object.setNote("org.apache.catalina.authenticator.SESSION_ID", string4);
                }
            }
        } else if (bl) {
            object = request.getSessionInternal(true);
        }
        if (object != null && bl2) {
            object.setAuthType(string);
            object.setPrincipal(principal);
        }
        if (this.sso == null) {
            return;
        }
        string4 = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (string4 == null) {
            string4 = this.sessionIdGenerator.generateSessionId();
            Cookie cookie = new Cookie(this.sso.getCookieName(), string4);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String string5 = this.sso.getCookieDomain();
            if (string5 != null) {
                cookie.setDomain(string5);
            }
            if (request.getServletContext().getSessionCookieConfig().isHttpOnly() || request.getContext().getUseHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            cookie.setAttribute("Partitioned", Boolean.toString(request.getContext().getUsePartitioned()));
            httpServletResponse.addCookie(cookie);
            this.sso.register(string4, principal, string, string2, string3);
            request.setNote("org.apache.catalina.request.SSOID", string4);
        } else {
            if (principal == null) {
                this.sso.deregister(string4);
                request.removeNote("org.apache.catalina.request.SSOID");
                return;
            }
            this.sso.update(string4, principal, string, string2, string3);
        }
        if (object == null) {
            object = request.getSessionInternal(true);
        }
        this.sso.associate(string4, (Session)object);
    }

    protected String changeSessionID(Request request, Session session) {
        String string = null;
        if (this.log.isDebugEnabled()) {
            string = session.getId();
        }
        String string2 = request.changeSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("authenticator.changeSessionId", new Object[]{string, string2}));
        }
        return string2;
    }

    @Override
    public void login(String string, String string2, Request request) throws ServletException {
        Principal principal = this.doLogin(request, string, string2);
        this.register(request, request.getResponse(), principal, this.getAuthMethod(), string, string2);
    }

    protected abstract String getAuthMethod();

    protected Principal doLogin(Request request, String string, String string2) throws ServletException {
        Principal principal = this.context.getRealm().authenticate(string, string2);
        if (principal == null) {
            throw new ServletException(sm.getString("authenticator.loginFail"));
        }
        return principal;
    }

    @Override
    public void logout(Request request) {
        Object object;
        AuthConfigProvider authConfigProvider = this.getJaspicProvider();
        if (authConfigProvider != null) {
            object = new MessageInfoImpl(request, request.getResponse(), true);
            Subject subject = (Subject)request.getNote("org.apache.catalina.authenticator.jaspic.SUBJECT");
            if (subject != null) {
                try {
                    ServerAuthConfig serverAuthConfig = authConfigProvider.getServerAuthConfig("HttpServlet", this.jaspicAppContextID, this.getCallbackHandler());
                    String string = serverAuthConfig.getAuthContextID((MessageInfo)object);
                    ServerAuthContext serverAuthContext = serverAuthConfig.getAuthContext(string, null, null);
                    serverAuthContext.cleanSubject((MessageInfo)object, subject);
                }
                catch (AuthException authException) {
                    this.log.debug((Object)sm.getString("authenticator.jaspicCleanSubjectFail"), (Throwable)authException);
                }
            }
        }
        if ((object = request.getPrincipal()) instanceof TomcatPrincipal) {
            try {
                ((TomcatPrincipal)object).logout();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.log.debug((Object)sm.getString("authenticator.tomcatPrincipalLogoutFail"), throwable);
            }
        }
        this.register(request, request.getResponse(), null, null, null, null);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        ServletContext servletContext = this.context.getServletContext();
        this.jaspicAppContextID = servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
        Container container = this.context.getParent();
        while (this.sso == null && container != null) {
            Valve[] valveArray;
            for (Valve valve : valveArray = container.getPipeline().getValves()) {
                if (!(valve instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valve;
                break;
            }
            if (this.sso != null) continue;
            container = container.getParent();
        }
        if (this.log.isDebugEnabled()) {
            if (this.sso != null) {
                this.log.debug((Object)sm.getString("authenticator.sso", new Object[]{this.sso}));
            } else {
                this.log.trace((Object)"No SingleSignOn Valve is present");
            }
        }
        this.sessionIdGenerator = new StandardSessionIdGenerator();
        this.sessionIdGenerator.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        this.sessionIdGenerator.setSecureRandomClass(this.getSecureRandomClass());
        this.sessionIdGenerator.setSecureRandomProvider(this.getSecureRandomProvider());
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.sso = null;
    }

    protected boolean isPreemptiveAuthPossible(Request request) {
        return false;
    }

    private AuthConfigProvider getJaspicProvider() {
        Optional<AuthConfigProvider> optional = this.jaspicProvider;
        if (optional == null) {
            optional = this.findJaspicProvider();
        }
        return optional.orElse(null);
    }

    private Optional<AuthConfigProvider> findJaspicProvider() {
        AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
        Optional<AuthConfigProvider> optional = authConfigFactory == null ? Optional.empty() : Optional.ofNullable(authConfigFactory.getConfigProvider("HttpServlet", this.jaspicAppContextID, (RegistrationListener)this));
        this.jaspicProvider = optional;
        return optional;
    }

    public void notify(String string, String string2) {
        this.findJaspicProvider();
    }

    protected static enum AllowCorsPreflight {
        NEVER,
        FILTER,
        ALWAYS;

    }

    private static class JaspicState {
        public MessageInfo messageInfo = null;
        public ServerAuthContext serverAuthContext = null;

        private JaspicState() {
        }
    }
}

