/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.lang.reflect.Array;
import scala.Array$;
import scala.MatchError;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Vector;

public final class NewVectorIterator<A>
extends AbstractIterator<A>
implements Cloneable {
    private final Vector<A> v;
    private int totalLength;
    private final int sliceCount;
    private Object[] a1;
    private Object[][] a2;
    private Object[][][] a3;
    private Object[][][][] a4;
    private Object[][][][][] a5;
    private Object[][][][][][] a6;
    private int a1len;
    public int scala$collection$immutable$NewVectorIterator$$i1;
    private int oldPos;
    public int scala$collection$immutable$NewVectorIterator$$len1;
    private int sliceIdx;
    private int sliceDim;
    private int sliceStart;
    private int sliceEnd;

    @Override
    public final int knownSize() {
        return this.scala$collection$immutable$NewVectorIterator$$len1 - this.scala$collection$immutable$NewVectorIterator$$i1;
    }

    @Override
    public final boolean hasNext() {
        return this.scala$collection$immutable$NewVectorIterator$$len1 > this.scala$collection$immutable$NewVectorIterator$$i1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final A next() {
        void var1_1;
        if (this.scala$collection$immutable$NewVectorIterator$$i1 == this.a1len) {
            this.advance();
        }
        Object r = this.a1[this.scala$collection$immutable$NewVectorIterator$$i1];
        ++this.scala$collection$immutable$NewVectorIterator$$i1;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void advanceSlice() {
        void var1_1;
        void var3_3;
        int n;
        Object[] slice;
        if (!(this.scala$collection$immutable$NewVectorIterator$$len1 > this.scala$collection$immutable$NewVectorIterator$$i1)) {
            Iterator$.scala$collection$Iterator$$_empty.next();
        }
        do {
            ++this.sliceIdx;
        } while ((slice = this.v.vectorSlice(this.sliceIdx)).length == 0);
        this.sliceStart = this.sliceEnd;
        int vectorSliceDim_idx = this.sliceIdx;
        int vectorSliceDim_c = this.sliceCount / 2;
        n = this.sliceDim = vectorSliceDim_c + 1 - Math.abs((int)(n - var3_3));
        switch (n) {
            case 1: {
                this.a1 = slice;
                break;
            }
            case 2: {
                this.a2 = (Object[][])slice;
                break;
            }
            case 3: {
                this.a3 = (Object[][][])slice;
                break;
            }
            case 4: {
                this.a4 = (Object[][][][])slice;
                break;
            }
            case 5: {
                this.a5 = (Object[][][][][])slice;
                break;
            }
            case 6: {
                this.a6 = (Object[][][][][][])slice;
                break;
            }
            default: {
                throw new MatchError(n);
            }
        }
        this.sliceEnd = this.sliceStart + ((void)var1_1).length * (1 << 5 * (this.sliceDim - 1));
        if (this.sliceEnd > this.totalLength) {
            this.sliceEnd = this.totalLength;
        }
        if (this.sliceDim > 1) {
            this.oldPos = (1 << 5 * this.sliceDim) - 1;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void advance() {
        int pos = this.scala$collection$immutable$NewVectorIterator$$i1 - this.scala$collection$immutable$NewVectorIterator$$len1 + this.totalLength;
        if (pos == this.sliceEnd) {
            this.advanceSlice();
        }
        if (this.sliceDim > 1) {
            void var1_1;
            void var2_2;
            int io = pos - this.sliceStart;
            int xor = this.oldPos ^ io;
            this.advanceA(io, (int)var2_2);
            this.oldPos = var1_1;
        }
        this.scala$collection$immutable$NewVectorIterator$$len1 -= this.scala$collection$immutable$NewVectorIterator$$i1;
        this.a1len = Math.min(this.a1.length, this.scala$collection$immutable$NewVectorIterator$$len1);
        this.scala$collection$immutable$NewVectorIterator$$i1 = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void advanceA(int io, int xor) {
        void var1_1;
        void var2_2;
        if (xor < 1024) {
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 32768) {
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[0];
            return;
        }
        if (xor < 0x100000) {
            this.a3 = this.a4[io >>> 15 & 0x1F];
            this.a2 = this.a3[0];
            this.a1 = this.a2[0];
            return;
        }
        if (var2_2 < 0x2000000) {
            this.a4 = this.a5[io >>> 20 & 0x1F];
            this.a3 = this.a4[0];
            this.a2 = this.a3[0];
            this.a1 = this.a2[0];
            return;
        }
        this.a5 = this.a6[var1_1 >>> 25];
        this.a4 = this.a5[0];
        this.a3 = this.a4[0];
        this.a2 = this.a3[0];
        this.a1 = this.a2[0];
    }

    /*
     * WARNING - void declaration
     */
    private void setA(int io, int xor) {
        void var1_1;
        void var2_2;
        if (xor < 1024) {
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 32768) {
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 0x100000) {
            this.a3 = this.a4[io >>> 15 & 0x1F];
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (var2_2 < 0x2000000) {
            this.a4 = this.a5[io >>> 20 & 0x1F];
            this.a3 = this.a4[io >>> 15 & 0x1F];
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        this.a5 = this.a6[io >>> 25];
        this.a4 = this.a5[io >>> 20 & 0x1F];
        this.a3 = this.a4[io >>> 15 & 0x1F];
        this.a2 = this.a3[io >>> 10 & 0x1F];
        this.a1 = this.a2[var1_1 >>> 5 & 0x1F];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<A> drop(int n) {
        if (n > 0) {
            int newpos = Math.min(this.scala$collection$immutable$NewVectorIterator$$i1 - this.scala$collection$immutable$NewVectorIterator$$len1 + this.totalLength + n, this.totalLength);
            if (newpos == this.totalLength) {
                this.scala$collection$immutable$NewVectorIterator$$i1 = 0;
                this.scala$collection$immutable$NewVectorIterator$$len1 = 0;
                this.a1len = 0;
            } else {
                void var1_1;
                void var2_2;
                while (newpos >= this.sliceEnd) {
                    this.advanceSlice();
                }
                int io = newpos - this.sliceStart;
                if (this.sliceDim > 1) {
                    void var3_3;
                    int xor = this.oldPos ^ io;
                    this.setA(io, (int)var3_3);
                    this.oldPos = io;
                }
                this.a1len = this.a1.length;
                this.scala$collection$immutable$NewVectorIterator$$i1 = var2_2 & 0x1F;
                this.scala$collection$immutable$NewVectorIterator$$len1 = this.scala$collection$immutable$NewVectorIterator$$i1 + (this.totalLength - var1_1);
                if (this.a1len > this.scala$collection$immutable$NewVectorIterator$$len1) {
                    this.a1len = this.scala$collection$immutable$NewVectorIterator$$len1;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<A> take(int n) {
        if (n < this.scala$collection$immutable$NewVectorIterator$$len1 - this.scala$collection$immutable$NewVectorIterator$$i1) {
            void var1_1;
            int trunc = this.scala$collection$immutable$NewVectorIterator$$len1 - this.scala$collection$immutable$NewVectorIterator$$i1 - Math.max(0, n);
            this.totalLength -= trunc;
            this.scala$collection$immutable$NewVectorIterator$$len1 -= var1_1;
            if (this.scala$collection$immutable$NewVectorIterator$$len1 < this.a1len) {
                this.a1len = this.scala$collection$immutable$NewVectorIterator$$len1;
            }
            if (this.totalLength < this.sliceEnd) {
                this.sliceEnd = this.totalLength;
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> int copyToArray(Object xs, int start, int len) {
        void var3_3;
        int count;
        int xsLen = Array.getLength(xs);
        int elemsToCopyToArray_srcLen = this.scala$collection$immutable$NewVectorIterator$$len1 - this.scala$collection$immutable$NewVectorIterator$$i1;
        int total = Math.max(Math.min(Math.min(len, elemsToCopyToArray_srcLen), xsLen - start), 0);
        boolean isBoxed = xs instanceof Object[];
        for (int copied = 0; copied < total; copied += count) {
            if (this.scala$collection$immutable$NewVectorIterator$$i1 == this.a1len) {
                this.advance();
            }
            count = Math.min(total - copied, this.a1.length - this.scala$collection$immutable$NewVectorIterator$$i1);
            if (isBoxed) {
                System.arraycopy(this.a1, this.scala$collection$immutable$NewVectorIterator$$i1, xs, start + copied, count);
            } else {
                Array$.MODULE$.copy(this.a1, this.scala$collection$immutable$NewVectorIterator$$i1, xs, start + copied, count);
            }
            this.scala$collection$immutable$NewVectorIterator$$i1 += count;
        }
        return (int)var3_3;
    }

    @Override
    public final Vector<A> toVector() {
        return (Vector)this.v.slice(this.scala$collection$immutable$NewVectorIterator$$i1 - this.scala$collection$immutable$NewVectorIterator$$len1 + this.totalLength, this.totalLength);
    }

    /*
     * WARNING - void declaration
     */
    public NewVectorIterator(Vector<A> v, int totalLength, int sliceCount) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.v = v;
        this.totalLength = var2_2;
        this.sliceCount = var3_3;
        this.a1 = var1_1.prefix1();
        this.a1len = this.a1.length;
        this.scala$collection$immutable$NewVectorIterator$$i1 = 0;
        this.oldPos = 0;
        this.scala$collection$immutable$NewVectorIterator$$len1 = this.totalLength;
        this.sliceIdx = 0;
        this.sliceDim = 1;
        this.sliceStart = 0;
        this.sliceEnd = this.a1len;
    }
}

