\name{GradientImageFilter}
\alias{GradientImageFilter}
\title{GradientImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the gradient of an image using directional derivatives.
GradientImageFilter}
\details{
Computes the gradient of an image using directional derivatives. The
directional derivative at each pixel location is computed by
convolution with a first-order derivative operator.
The second template parameter defines the value type used in the
derivative operator (defaults to float). The third template parameter
defines the value type used for output image (defaults to float). The
output image is defined as a covariant vector image whose value type
is specified as this third template parameter.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
Gradient for the procedural interface
itk::GradientImageFilter for the Doxygen on the original ITK class.
GradientImageFilter}
%C++ includes: sitkGradientImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseImageDirection() const:}{
The UseImageDirection flag determines whether image derivatives are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the derivatives are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to compute the derivatives in physical
space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.
}
\item{ GradientImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetUseImageDirection(bool UseImageDirection):}{
The UseImageDirection flag determines whether image derivatives are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the derivatives are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to compute the derivatives in physical
space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageDirectionOff():}{}
\item{Self UseImageDirectionOn():}{
Set the value of UseImageDirection to true or false respectfully.
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~GradientImageFilter():}{
Destructor
}
}
}
