/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.ElementSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.wssecurity.AttributedDateTime;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObjectMarshaller;
import org.w3c.dom.Element;

public class AttributedDateTimeMarshaller
extends AbstractWSSecurityObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        AttributedDateTime dateTime = (AttributedDateTime)xmlObject;
        if (!Strings.isNullOrEmpty((String)dateTime.getWSUId())) {
            XMLObjectSupport.marshallAttribute(AttributedDateTime.WSU_ID_ATTR_NAME, dateTime.getWSUId(), domElement, true);
        }
        XMLObjectSupport.marshallAttributeMap(dateTime.getUnknownAttributes(), domElement);
    }

    @Override
    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(AttributedDateTime.WSU_ID_ATTR_NAME, domElement, true);
        super.marshallAttributeIDness(xmlObject, domElement);
    }

    @Override
    protected void marshallElementContent(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        AttributedDateTime dateTime = (AttributedDateTime)xmlObject;
        ElementSupport.appendTextContent(domElement, dateTime.getValue());
    }
}

