/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AuthinfoResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AuthinfoResponse> {
    @Nonnull
    private final List<String> backendRoles;
    @Nonnull
    private final List<String> customAttributeNames;
    @Nullable
    private final String peerCertificates;
    @Nullable
    private final String principal;
    @Nullable
    private final String remoteAddress;
    @Nonnull
    private final List<String> roles;
    @Nullable
    private final String sizeOfBackendroles;
    @Nullable
    private final String sizeOfCustomAttributes;
    @Nullable
    private final String sizeOfUser;
    @Nullable
    private final String ssoLogoutUrl;
    @Nonnull
    private final Map<String, Boolean> tenants;
    @Nullable
    private final String user;
    @Nullable
    private final String userName;
    @Nullable
    private final String userRequestedTenant;
    public static final JsonpDeserializer<AuthinfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AuthinfoResponse::setupAuthinfoResponseDeserializer);

    private AuthinfoResponse(Builder builder) {
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.customAttributeNames = ApiTypeHelper.unmodifiable(builder.customAttributeNames);
        this.peerCertificates = builder.peerCertificates;
        this.principal = builder.principal;
        this.remoteAddress = builder.remoteAddress;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.sizeOfBackendroles = builder.sizeOfBackendroles;
        this.sizeOfCustomAttributes = builder.sizeOfCustomAttributes;
        this.sizeOfUser = builder.sizeOfUser;
        this.ssoLogoutUrl = builder.ssoLogoutUrl;
        this.tenants = ApiTypeHelper.unmodifiable(builder.tenants);
        this.user = builder.user;
        this.userName = builder.userName;
        this.userRequestedTenant = builder.userRequestedTenant;
    }

    public static AuthinfoResponse of(Function<Builder, ObjectBuilder<AuthinfoResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nonnull
    public final List<String> customAttributeNames() {
        return this.customAttributeNames;
    }

    @Nullable
    public final String peerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    public final String principal() {
        return this.principal;
    }

    @Nullable
    public final String remoteAddress() {
        return this.remoteAddress;
    }

    @Nonnull
    public final List<String> roles() {
        return this.roles;
    }

    @Nullable
    public final String sizeOfBackendroles() {
        return this.sizeOfBackendroles;
    }

    @Nullable
    public final String sizeOfCustomAttributes() {
        return this.sizeOfCustomAttributes;
    }

    @Nullable
    public final String sizeOfUser() {
        return this.sizeOfUser;
    }

    @Nullable
    public final String ssoLogoutUrl() {
        return this.ssoLogoutUrl;
    }

    @Nonnull
    public final Map<String, Boolean> tenants() {
        return this.tenants;
    }

    @Nullable
    public final String user() {
        return this.user;
    }

    @Nullable
    public final String userName() {
        return this.userName;
    }

    @Nullable
    public final String userRequestedTenant() {
        return this.userRequestedTenant;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String string : this.backendRoles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.customAttributeNames)) {
            generator.writeKey("custom_attribute_names");
            generator.writeStartArray();
            for (String string : this.customAttributeNames) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.peerCertificates != null) {
            generator.writeKey("peer_certificates");
            generator.write(this.peerCertificates);
        }
        if (this.principal != null) {
            generator.writeKey("principal");
            generator.write(this.principal);
        }
        if (this.remoteAddress != null) {
            generator.writeKey("remote_address");
            generator.write(this.remoteAddress);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.sizeOfBackendroles != null) {
            generator.writeKey("size_of_backendroles");
            generator.write(this.sizeOfBackendroles);
        }
        if (this.sizeOfCustomAttributes != null) {
            generator.writeKey("size_of_custom_attributes");
            generator.write(this.sizeOfCustomAttributes);
        }
        if (this.sizeOfUser != null) {
            generator.writeKey("size_of_user");
            generator.write(this.sizeOfUser);
        }
        if (this.ssoLogoutUrl != null) {
            generator.writeKey("sso_logout_url");
            generator.write(this.ssoLogoutUrl);
        }
        if (ApiTypeHelper.isDefined(this.tenants)) {
            generator.writeKey("tenants");
            generator.writeStartObject();
            for (Map.Entry entry : this.tenants.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write(((Boolean)entry.getValue()).booleanValue());
            }
            generator.writeEnd();
        }
        if (this.user != null) {
            generator.writeKey("user");
            generator.write(this.user);
        }
        if (this.userName != null) {
            generator.writeKey("user_name");
            generator.write(this.userName);
        }
        if (this.userRequestedTenant != null) {
            generator.writeKey("user_requested_tenant");
            generator.write(this.userRequestedTenant);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAuthinfoResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::customAttributeNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "custom_attribute_names");
        op.add(Builder::peerCertificates, JsonpDeserializer.stringDeserializer(), "peer_certificates");
        op.add(Builder::principal, JsonpDeserializer.stringDeserializer(), "principal");
        op.add(Builder::remoteAddress, JsonpDeserializer.stringDeserializer(), "remote_address");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::sizeOfBackendroles, JsonpDeserializer.stringDeserializer(), "size_of_backendroles");
        op.add(Builder::sizeOfCustomAttributes, JsonpDeserializer.stringDeserializer(), "size_of_custom_attributes");
        op.add(Builder::sizeOfUser, JsonpDeserializer.stringDeserializer(), "size_of_user");
        op.add(Builder::ssoLogoutUrl, JsonpDeserializer.stringDeserializer(), "sso_logout_url");
        op.add(Builder::tenants, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()), "tenants");
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user");
        op.add(Builder::userName, JsonpDeserializer.stringDeserializer(), "user_name");
        op.add(Builder::userRequestedTenant, JsonpDeserializer.stringDeserializer(), "user_requested_tenant");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.backendRoles);
        result = 31 * result + Objects.hashCode(this.customAttributeNames);
        result = 31 * result + Objects.hashCode(this.peerCertificates);
        result = 31 * result + Objects.hashCode(this.principal);
        result = 31 * result + Objects.hashCode(this.remoteAddress);
        result = 31 * result + Objects.hashCode(this.roles);
        result = 31 * result + Objects.hashCode(this.sizeOfBackendroles);
        result = 31 * result + Objects.hashCode(this.sizeOfCustomAttributes);
        result = 31 * result + Objects.hashCode(this.sizeOfUser);
        result = 31 * result + Objects.hashCode(this.ssoLogoutUrl);
        result = 31 * result + Objects.hashCode(this.tenants);
        result = 31 * result + Objects.hashCode(this.user);
        result = 31 * result + Objects.hashCode(this.userName);
        result = 31 * result + Objects.hashCode(this.userRequestedTenant);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthinfoResponse other = (AuthinfoResponse)o;
        return Objects.equals(this.backendRoles, other.backendRoles) && Objects.equals(this.customAttributeNames, other.customAttributeNames) && Objects.equals(this.peerCertificates, other.peerCertificates) && Objects.equals(this.principal, other.principal) && Objects.equals(this.remoteAddress, other.remoteAddress) && Objects.equals(this.roles, other.roles) && Objects.equals(this.sizeOfBackendroles, other.sizeOfBackendroles) && Objects.equals(this.sizeOfCustomAttributes, other.sizeOfCustomAttributes) && Objects.equals(this.sizeOfUser, other.sizeOfUser) && Objects.equals(this.ssoLogoutUrl, other.ssoLogoutUrl) && Objects.equals(this.tenants, other.tenants) && Objects.equals(this.user, other.user) && Objects.equals(this.userName, other.userName) && Objects.equals(this.userRequestedTenant, other.userRequestedTenant);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, AuthinfoResponse> {
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private List<String> customAttributeNames;
        @Nullable
        private String peerCertificates;
        @Nullable
        private String principal;
        @Nullable
        private String remoteAddress;
        @Nullable
        private List<String> roles;
        @Nullable
        private String sizeOfBackendroles;
        @Nullable
        private String sizeOfCustomAttributes;
        @Nullable
        private String sizeOfUser;
        @Nullable
        private String ssoLogoutUrl;
        @Nullable
        private Map<String, Boolean> tenants;
        @Nullable
        private String user;
        @Nullable
        private String userName;
        @Nullable
        private String userRequestedTenant;

        public Builder() {
        }

        private Builder(AuthinfoResponse o) {
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.customAttributeNames = Builder._listCopy(o.customAttributeNames);
            this.peerCertificates = o.peerCertificates;
            this.principal = o.principal;
            this.remoteAddress = o.remoteAddress;
            this.roles = Builder._listCopy(o.roles);
            this.sizeOfBackendroles = o.sizeOfBackendroles;
            this.sizeOfCustomAttributes = o.sizeOfCustomAttributes;
            this.sizeOfUser = o.sizeOfUser;
            this.ssoLogoutUrl = o.ssoLogoutUrl;
            this.tenants = Builder._mapCopy(o.tenants);
            this.user = o.user;
            this.userName = o.userName;
            this.userRequestedTenant = o.userRequestedTenant;
        }

        private Builder(Builder o) {
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.customAttributeNames = Builder._listCopy(o.customAttributeNames);
            this.peerCertificates = o.peerCertificates;
            this.principal = o.principal;
            this.remoteAddress = o.remoteAddress;
            this.roles = Builder._listCopy(o.roles);
            this.sizeOfBackendroles = o.sizeOfBackendroles;
            this.sizeOfCustomAttributes = o.sizeOfCustomAttributes;
            this.sizeOfUser = o.sizeOfUser;
            this.ssoLogoutUrl = o.ssoLogoutUrl;
            this.tenants = Builder._mapCopy(o.tenants);
            this.user = o.user;
            this.userName = o.userName;
            this.userRequestedTenant = o.userRequestedTenant;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder customAttributeNames(List<String> list) {
            this.customAttributeNames = Builder._listAddAll(this.customAttributeNames, list);
            return this;
        }

        @Nonnull
        public final Builder customAttributeNames(String value, String ... values) {
            this.customAttributeNames = Builder._listAdd(this.customAttributeNames, value, values);
            return this;
        }

        @Nonnull
        public final Builder peerCertificates(@Nullable String value) {
            this.peerCertificates = value;
            return this;
        }

        @Nonnull
        public final Builder principal(@Nullable String value) {
            this.principal = value;
            return this;
        }

        @Nonnull
        public final Builder remoteAddress(@Nullable String value) {
            this.remoteAddress = value;
            return this;
        }

        @Nonnull
        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        @Nonnull
        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        @Nonnull
        public final Builder sizeOfBackendroles(@Nullable String value) {
            this.sizeOfBackendroles = value;
            return this;
        }

        @Nonnull
        public final Builder sizeOfCustomAttributes(@Nullable String value) {
            this.sizeOfCustomAttributes = value;
            return this;
        }

        @Nonnull
        public final Builder sizeOfUser(@Nullable String value) {
            this.sizeOfUser = value;
            return this;
        }

        @Nonnull
        public final Builder ssoLogoutUrl(@Nullable String value) {
            this.ssoLogoutUrl = value;
            return this;
        }

        @Nonnull
        public final Builder tenants(Map<String, Boolean> map) {
            this.tenants = Builder._mapPutAll(this.tenants, map);
            return this;
        }

        @Nonnull
        public final Builder tenants(String key, Boolean value) {
            this.tenants = Builder._mapPut(this.tenants, key, value);
            return this;
        }

        @Nonnull
        public final Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        @Nonnull
        public final Builder userName(@Nullable String value) {
            this.userName = value;
            return this;
        }

        @Nonnull
        public final Builder userRequestedTenant(@Nullable String value) {
            this.userRequestedTenant = value;
            return this;
        }

        @Override
        @Nonnull
        public AuthinfoResponse build() {
            this._checkSingleUse();
            return new AuthinfoResponse(this);
        }
    }
}

