/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class Time
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Time> _DESERIALIZER = JsonpDeserializer.lazy(Time::buildTimeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Time(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return String.valueOf(this.offset());
            }
            case 1: {
                return this.time();
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    private Time(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Time of(Function<Builder, ObjectBuilder<Time>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isOffset() {
        return this._kind == Kind.Offset;
    }

    public Integer offset() {
        return (Integer)TaggedUnionUtils.get(this, Kind.Offset);
    }

    public boolean isTime() {
        return this._kind == Kind.Time;
    }

    public String time() {
        return (String)TaggedUnionUtils.get(this, Kind.Time);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write(((Integer)this._value).intValue());
                    break;
                }
                case 1: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<Time> buildTimeDeserializer() {
        return new UnionDeserializer.Builder<Time, Kind, Object>(Time::new, false).addMember(Kind.Offset, JsonpDeserializer.integerDeserializer()).addMember(Kind.Time, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Time> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Time> offset(Integer v) {
            this._kind = Kind.Offset;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Time> time(String v) {
            this._kind = Kind.Time;
            this._value = v;
            return this;
        }

        @Override
        public Time build() {
            this._checkSingleUse();
            return new Time(this);
        }
    }

    public static enum Kind {
        Offset,
        Time;

    }
}

