/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.Closeable;
import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.neuralsearch.sparse.codec.CodecUtilWrapper;

public class SparseTermsLuceneWriter {
    private IndexOutput termsOut;
    private final String codecName;
    private final int version;
    private final CodecUtilWrapper codecUtilWrapper;

    public void init(IndexOutput termsOut, SegmentWriteState state) throws IOException {
        this.termsOut = termsOut;
        this.codecUtilWrapper.writeIndexHeader((DataOutput)termsOut, this.codecName, this.version, state.segmentInfo.getId(), state.segmentSuffix);
    }

    public void close(long startFp) throws IOException {
        this.termsOut.writeLong(startFp);
        this.codecUtilWrapper.writeFooter(this.termsOut);
    }

    public void writeFieldCount(int fieldCount) throws IOException {
        this.termsOut.writeVInt(fieldCount);
    }

    public void writeFieldNumber(int fieldNumber) throws IOException {
        this.termsOut.writeVInt(fieldNumber);
    }

    public void writeTermsSize(long termsSize) throws IOException {
        this.termsOut.writeVLong(termsSize);
    }

    public void writeTerm(BytesRef term, BlockTermState state) throws IOException {
        this.termsOut.writeVInt(term.length);
        this.termsOut.writeBytes(term.bytes, term.offset, term.length);
        this.termsOut.writeVLong(state.blockFilePointer);
    }

    public void closeWithException() {
        IOUtils.closeWhileHandlingException((Closeable)this.termsOut);
    }

    @Generated
    public SparseTermsLuceneWriter(String codecName, int version, CodecUtilWrapper codecUtilWrapper) {
        this.codecName = codecName;
        this.version = version;
        this.codecUtilWrapper = codecUtilWrapper;
    }
}

