/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NeuralQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, NeuralQuery> {
    @Nonnull
    private final String field;
    @Nullable
    private final Query filter;
    @Nullable
    private final Integer k;
    @Nullable
    private final Float maxDistance;
    @Nullable
    private final Float minScore;
    @Nullable
    private final String modelId;
    @Nullable
    private final String queryImage;
    @Nullable
    private final String queryText;
    public static final JsonpDeserializer<NeuralQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NeuralQuery::setupNeuralQueryDeserializer);

    private NeuralQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.filter = builder.filter;
        this.k = builder.k;
        this.maxDistance = builder.maxDistance;
        this.minScore = builder.minScore;
        this.modelId = builder.modelId;
        this.queryImage = builder.queryImage;
        this.queryText = builder.queryText;
    }

    public static NeuralQuery of(Function<Builder, ObjectBuilder<NeuralQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Neural;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final Integer k() {
        return this.k;
    }

    @Nullable
    public final Float maxDistance() {
        return this.maxDistance;
    }

    @Nullable
    public final Float minScore() {
        return this.minScore;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String queryImage() {
        return this.queryImage;
    }

    @Nullable
    public final String queryText() {
        return this.queryText;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.k != null) {
            generator.writeKey("k");
            generator.write(this.k.intValue());
        }
        if (this.maxDistance != null) {
            generator.writeKey("max_distance");
            generator.write((double)this.maxDistance.floatValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write((double)this.minScore.floatValue());
        }
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (this.queryImage != null) {
            generator.writeKey("query_image");
            generator.write(this.queryImage);
        }
        if (this.queryText != null) {
            generator.writeKey("query_text");
            generator.write(this.queryText);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNeuralQueryDeserializer(ObjectDeserializer<Builder> op) {
        NeuralQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::maxDistance, JsonpDeserializer.floatDeserializer(), "max_distance");
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::queryImage, JsonpDeserializer.stringDeserializer(), "query_image");
        op.add(Builder::queryText, JsonpDeserializer.stringDeserializer(), "query_text");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.k);
        result = 31 * result + Objects.hashCode(this.maxDistance);
        result = 31 * result + Objects.hashCode(this.minScore);
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.queryImage);
        result = 31 * result + Objects.hashCode(this.queryText);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NeuralQuery other = (NeuralQuery)o;
        return this.field.equals(other.field) && Objects.equals(this.filter, other.filter) && Objects.equals(this.k, other.k) && Objects.equals(this.maxDistance, other.maxDistance) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.queryImage, other.queryImage) && Objects.equals(this.queryText, other.queryText);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NeuralQuery> {
        private String field;
        @Nullable
        private Query filter;
        @Nullable
        private Integer k;
        @Nullable
        private Float maxDistance;
        @Nullable
        private Float minScore;
        @Nullable
        private String modelId;
        @Nullable
        private String queryImage;
        @Nullable
        private String queryText;

        public Builder() {
        }

        private Builder(NeuralQuery o) {
            super(o);
            this.field = o.field;
            this.filter = o.filter;
            this.k = o.k;
            this.maxDistance = o.maxDistance;
            this.minScore = o.minScore;
            this.modelId = o.modelId;
            this.queryImage = o.queryImage;
            this.queryText = o.queryText;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.filter = o.filter;
            this.k = o.k;
            this.maxDistance = o.maxDistance;
            this.minScore = o.minScore;
            this.modelId = o.modelId;
            this.queryImage = o.queryImage;
            this.queryText = o.queryText;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder k(@Nullable Integer value) {
            this.k = value;
            return this;
        }

        @Nonnull
        public final Builder maxDistance(@Nullable Float value) {
            this.maxDistance = value;
            return this;
        }

        @Nonnull
        public final Builder minScore(@Nullable Float value) {
            this.minScore = value;
            return this;
        }

        @Nonnull
        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder queryImage(@Nullable String value) {
            this.queryImage = value;
            return this;
        }

        @Nonnull
        public final Builder queryText(@Nullable String value) {
            this.queryText = value;
            return this;
        }

        @Override
        @Nonnull
        public NeuralQuery build() {
            this._checkSingleUse();
            return new NeuralQuery(this);
        }
    }
}

