/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tribuo.Example;
import org.tribuo.Output;

public class Prediction<T extends Output<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Example<T> example;
    private final T output;
    private final boolean probability;
    private final int numUsed;
    private final int exampleSize;
    private final Map<String, T> outputScores;

    private Prediction(T output, Map<String, T> outputScores, int numUsed, int exampleSize, Example<T> example, boolean probability) {
        this.example = example;
        this.outputScores = outputScores;
        this.numUsed = numUsed;
        this.exampleSize = exampleSize;
        this.output = output;
        this.probability = probability;
    }

    public Prediction(T output, Map<String, T> outputScores, int numUsed, Example<T> example, boolean probability) {
        this(output, outputScores, numUsed, example.size(), example, probability);
    }

    public Prediction(T output, int numUsed, Example<T> example) {
        this(output, Collections.emptyMap(), numUsed, example.size(), example, false);
    }

    public Prediction(Prediction<T> other, int numUsed, Example<T> example) {
        this(other.output, new LinkedHashMap<String, T>(other.outputScores), numUsed, example.size(), example, other.probability);
    }

    public T getOutput() {
        return this.output;
    }

    public int getNumActiveFeatures() {
        return this.numUsed;
    }

    public int getExampleSize() {
        return this.exampleSize;
    }

    public Example<T> getExample() {
        return this.example;
    }

    public Map<String, T> getOutputScores() {
        return this.outputScores;
    }

    public boolean hasProbabilities() {
        return this.probability;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Prediction(maxLabel=");
        buffer.append(this.output);
        buffer.append(",outputScores={");
        for (Map.Entry<String, T> e : this.outputScores.entrySet()) {
            buffer.append(e.toString());
            buffer.append(",");
        }
        buffer.delete(buffer.length() - 1, buffer.length());
        buffer.append("})");
        return buffer.toString();
    }

    public boolean distributionEquals(Prediction<T> other) {
        if (this.outputScores.size() != other.outputScores.size()) {
            return false;
        }
        for (Map.Entry<String, T> e : this.outputScores.entrySet()) {
            Output otherScore = (Output)other.outputScores.get(e.getKey());
            if (otherScore == null) {
                return false;
            }
            if (((Output)e.getValue()).fullEquals(otherScore)) continue;
            return false;
        }
        return true;
    }
}

