/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.script;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.knn.plugin.script.KNNScoringSpace;
import org.opensearch.knn.plugin.script.KNNScoringSpaceFactory;
import org.opensearch.knn.plugin.stats.KNNCounter;
import org.opensearch.script.ScoreScript;
import org.opensearch.search.lookup.SearchLookup;

public class KNNScoreScriptLeafFactory
implements ScoreScript.LeafFactory {
    private final Map<String, Object> params;
    private final SearchLookup lookup;
    private final String similaritySpace;
    private final String field;
    private final Object query;
    private final KNNScoringSpace knnScoringSpace;
    private final IndexSearcher searcher;

    public KNNScoreScriptLeafFactory(Map<String, Object> params, SearchLookup lookup, IndexSearcher searcher) {
        KNNCounter.SCRIPT_QUERY_REQUESTS.increment();
        this.params = params;
        this.lookup = lookup;
        this.field = this.getValue(params, "field").toString();
        this.similaritySpace = this.getValue(params, "space_type").toString();
        this.query = this.getValue(params, "query_value");
        this.searcher = searcher;
        this.knnScoringSpace = KNNScoringSpaceFactory.create(this.similaritySpace, this.query, lookup.doc().mapperService().fieldType(this.field));
    }

    private Object getValue(Map<String, Object> params, String fieldName) {
        Object value = params.get(fieldName);
        if (value != null) {
            return value;
        }
        KNNCounter.SCRIPT_QUERY_ERRORS.increment();
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Missing parameter [%s]", fieldName));
    }

    public boolean needs_score() {
        return false;
    }

    public ScoreScript newInstance(LeafReaderContext ctx) throws IOException {
        return this.knnScoringSpace.getScoreScript(this.params, this.field, this.lookup, ctx, this.searcher);
    }
}

