/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.spi;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public final class StatusHistoryModel
implements ToXContentObject,
Writeable {
    public static final String JOB_INDEX_NAME = "job_index_name";
    public static final String JOB_ID = "job_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String COMPLETION_STATUS = "completion_status";
    private final String jobIndexName;
    private final String jobId;
    private final Instant startTime;
    private final Instant endTime;
    private final int status;
    private final long seqNo;
    private final long primaryTerm;

    public StatusHistoryModel(String jobIndexName, String jobId, Instant startTime, Instant endTime, int status) {
        this(jobIndexName, jobId, startTime, endTime, status, -2L, 0L);
    }

    public StatusHistoryModel(String jobIndexName, String jobId, Instant startTime, Instant endTime, int status, long seqNo, long primaryTerm) {
        this.jobIndexName = jobIndexName;
        this.jobId = jobId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public StatusHistoryModel(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readInstant(), in.readOptionalInstant(), in.readInt(), in.readLong(), in.readLong());
    }

    public static StatusHistoryModel parse(XContentParser parser, long seqNo, long primaryTerm) throws IOException {
        String jobIndexName = null;
        String jobId = null;
        Instant startTime = null;
        Instant endTime = null;
        Integer status = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "job_index_name": {
                    jobIndexName = parser.text();
                    continue block14;
                }
                case "job_id": {
                    jobId = parser.text();
                    continue block14;
                }
                case "start_time": {
                    startTime = Instant.ofEpochSecond(parser.longValue());
                    continue block14;
                }
                case "end_time": {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue block14;
                    endTime = Instant.ofEpochSecond(parser.longValue());
                    continue block14;
                }
                case "completion_status": {
                    status = parser.intValue();
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
        return new StatusHistoryModel(Objects.requireNonNull(jobIndexName, "JobIndexName cannot be null"), Objects.requireNonNull(jobId, "JobId cannot be null"), Objects.requireNonNull(startTime, "startTime cannot be null"), endTime, (Integer)Objects.requireNonNull(status, "status cannot be null"), seqNo, primaryTerm);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(JOB_INDEX_NAME, this.jobIndexName).field(JOB_ID, this.jobId).field(START_TIME, this.startTime.getEpochSecond()).field(COMPLETION_STATUS, this.status);
        if (this.endTime != null) {
            builder.field(END_TIME, this.endTime.getEpochSecond());
        } else {
            builder.nullField(END_TIME);
        }
        return builder.endObject();
    }

    public String getJobIndexName() {
        return this.jobIndexName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public int getStatus() {
        return this.status;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusHistoryModel that = (StatusHistoryModel)o;
        return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && this.jobIndexName.equals(that.jobIndexName) && this.jobId.equals(that.jobId) && this.startTime.equals(that.startTime) && Objects.equals(this.endTime, that.endTime) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(this.jobIndexName, this.jobId, this.startTime, this.endTime, this.status, this.seqNo, this.primaryTerm);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobIndexName);
        out.writeString(this.jobId);
        out.writeInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
        out.writeInt(this.status);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
    }
}

