"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverrides = getOverrides;
exports.isFilterable = isFilterable;
exports.isNestedField = isNestedField;
exports.setOverrides = setOverrides;
var _osd_field_types = require("../../osd_field_types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const filterableTypes = (0, _osd_field_types.getFilterableOsdTypeNames)();
function setOverrides(overrides) {
  (0, _osd_field_types.setOsdFieldOverrides)(overrides);
}
function getOverrides() {
  return (0, _osd_field_types.getOsdFieldOverrides)();
}
function isFilterable(field) {
  if (getOverrides().filterable !== undefined) return !!getOverrides().filterable;
  return field.name === '_id' || field.scripted || Boolean(field.searchable && filterableTypes.includes(field.type));
}
function isNestedField(field) {
  var _field$subType;
  return !!((_field$subType = field.subType) !== null && _field$subType !== void 0 && _field$subType.nested);
}