var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });

// src/atn/LexerActionType.ts
var LexerActionType = {
  /** The type of a {@link LexerChannelAction} action. */
  CHANNEL: 0,
  /** The type of a {@link LexerCustomAction} action */
  CUSTOM: 1,
  /** The type of a {@link LexerModeAction} action. */
  MODE: 2,
  /** The type of a {@link LexerMoreAction} action. */
  MORE: 3,
  /** The type of a {@link LexerPopModeAction} action. */
  POP_MODE: 4,
  /** The type of a {@link LexerPushModeAction} action. */
  PUSH_MODE: 5,
  /** The type of a {@link LexerSkipAction} action. */
  SKIP: 6,
  /** The type of a {@link LexerTypeAction} action. */
  TYPE: 7
};

// src/atn/LexerSkipAction.ts
var LexerSkipAction = class _LexerSkipAction {
  static {
    __name(this, "LexerSkipAction");
  }
  /** Provides a singleton instance of this parameter-less lexer action. */
  static instance = new _LexerSkipAction();
  actionType;
  isPositionDependent = false;
  constructor() {
    this.actionType = LexerActionType.SKIP;
  }
  equals(obj) {
    return obj === this;
  }
  hashCode() {
    return LexerActionType.SKIP;
  }
  execute(lexer) {
    lexer.skip();
  }
  toString() {
    return "skip";
  }
};
export {
  LexerSkipAction
};
