/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene.search.vectorhighlight;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.opensearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.index.search.OpenSearchToParentBlockJoinQuery;
import org.opensearch.lucene.queries.BlendedTermQuery;

public class CustomFieldQuery
extends FieldQuery {
    public static final ThreadLocal<Boolean> highlightFilters = new ThreadLocal();

    public CustomFieldQuery(Query query, IndexReader reader, FastVectorHighlighter highlighter) throws IOException {
        this(query, reader, highlighter.isPhraseHighlight(), highlighter.isFieldMatch());
    }

    public CustomFieldQuery(Query query, IndexReader reader, boolean phraseHighlight, boolean fieldMatch) throws IOException {
        super(query, reader, phraseHighlight, fieldMatch);
        highlightFilters.remove();
    }

    protected void flatten(Query sourceQuery, IndexSearcher searcher, Collection<Query> flatQueries, float boost) throws IOException {
        if (sourceQuery instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)sourceQuery;
            sourceQuery = bq.getQuery();
            this.flatten(sourceQuery, searcher, flatQueries, boost *= bq.getBoost());
        } else if (sourceQuery instanceof SpanTermQuery) {
            super.flatten((Query)new TermQuery(((SpanTermQuery)sourceQuery).getTerm()), searcher, flatQueries, boost);
        } else if (sourceQuery instanceof ConstantScoreQuery) {
            this.flatten(((ConstantScoreQuery)sourceQuery).getQuery(), searcher, flatQueries, boost);
        } else if (sourceQuery instanceof FunctionScoreQuery) {
            this.flatten(((FunctionScoreQuery)sourceQuery).getSubQuery(), searcher, flatQueries, boost);
        } else if (sourceQuery instanceof MultiPhrasePrefixQuery) {
            this.flatten(sourceQuery.rewrite(searcher), searcher, flatQueries, boost);
        } else if (sourceQuery instanceof MultiPhraseQuery) {
            MultiPhraseQuery q = (MultiPhraseQuery)sourceQuery;
            this.convertMultiPhraseQuery(0, new int[q.getTermArrays().length], q, q.getTermArrays(), q.getPositions(), searcher, flatQueries);
        } else if (sourceQuery instanceof BlendedTermQuery) {
            BlendedTermQuery blendedTermQuery = (BlendedTermQuery)sourceQuery;
            this.flatten(blendedTermQuery.rewrite(searcher), searcher, flatQueries, boost);
        } else if (sourceQuery instanceof org.apache.lucene.queries.function.FunctionScoreQuery) {
            org.apache.lucene.queries.function.FunctionScoreQuery funcScoreQuery = (org.apache.lucene.queries.function.FunctionScoreQuery)sourceQuery;
            this.flatten(funcScoreQuery.getWrappedQuery(), searcher, flatQueries, boost);
        } else if (sourceQuery instanceof SynonymQuery) {
            SynonymQuery synQuery = (SynonymQuery)sourceQuery;
            for (Term term : synQuery.getTerms()) {
                this.flatten((Query)new TermQuery(term), searcher, flatQueries, boost);
            }
        } else if (sourceQuery instanceof OpenSearchToParentBlockJoinQuery) {
            Query childQuery = ((OpenSearchToParentBlockJoinQuery)sourceQuery).getChildQuery();
            if (childQuery != null) {
                this.flatten(childQuery, searcher, flatQueries, boost);
            }
        } else {
            super.flatten(sourceQuery, searcher, flatQueries, boost);
        }
    }

    private void convertMultiPhraseQuery(int currentPos, int[] termsIdx, MultiPhraseQuery orig, Term[][] terms, int[] pos, IndexSearcher searcher, Collection<Query> flatQueries) throws IOException {
        if (currentPos == 0) {
            int numTerms = 0;
            for (Term[] currentPosTerm : terms) {
                numTerms += currentPosTerm.length;
            }
            if (numTerms > 16) {
                Term[][] termArray = terms;
                int n = termArray.length;
                for (int i = 0; i < n; ++i) {
                    Term[] currentPosTerm;
                    for (Term term : currentPosTerm = termArray[i]) {
                        super.flatten((Query)new TermQuery(term), searcher, flatQueries, 1.0f);
                    }
                }
                return;
            }
        }
        if (currentPos == terms.length) {
            PhraseQuery.Builder queryBuilder = new PhraseQuery.Builder();
            queryBuilder.setSlop(orig.getSlop());
            for (int i = 0; i < termsIdx.length; ++i) {
                queryBuilder.add(terms[i][termsIdx[i]], pos[i]);
            }
            PhraseQuery query = queryBuilder.build();
            this.flatten((Query)query, searcher, flatQueries, 1.0f);
        } else {
            Term[] t = terms[currentPos];
            int i = 0;
            while (i < t.length) {
                termsIdx[currentPos] = i++;
                this.convertMultiPhraseQuery(currentPos + 1, termsIdx, orig, terms, pos, searcher, flatQueries);
            }
        }
    }
}

