/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.semver.expr;

import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.semver.expr.Expression;

public class Range
implements Expression {
    private final Version lowerBound;
    private final Version upperBound;
    private final boolean includeLower;
    private final boolean includeUpper;

    public Range() {
        this.lowerBound = Version.fromString("0.0.0");
        this.upperBound = Version.fromString("999.999.999");
        this.includeLower = true;
        this.includeUpper = true;
    }

    public Range(Version lowerBound, Version upperBound, boolean includeLower, boolean includeUpper) {
        if (lowerBound == null) {
            throw new IllegalArgumentException("Lower bound cannot be null");
        }
        if (upperBound == null) {
            throw new IllegalArgumentException("Upper bound cannot be null");
        }
        if (lowerBound.after(upperBound)) {
            throw new IllegalArgumentException("Lower bound must be less than or equal to upper bound");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public void updateRange(Range other) {
        if (other == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
    }

    @Override
    public boolean evaluate(Version rangeVersion, Version versionToEvaluate) {
        boolean satisfiesLower = this.includeLower ? versionToEvaluate.onOrAfter(this.lowerBound) : versionToEvaluate.after(this.lowerBound);
        boolean satisfiesUpper = this.includeUpper ? versionToEvaluate.onOrBefore(this.upperBound) : versionToEvaluate.before(this.upperBound);
        return satisfiesLower && satisfiesUpper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.includeLower == range.includeLower && this.includeUpper == range.includeUpper && Objects.equals(this.lowerBound, range.lowerBound) && Objects.equals(this.upperBound, range.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.includeLower, this.includeUpper);
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public Version getLowerBound() {
        return this.lowerBound;
    }

    public Version getUpperBound() {
        return this.upperBound;
    }
}

