/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.protobufs.MatchPhraseQuery;
import org.opensearch.protobufs.ZeroTermsQuery;

class MatchPhraseQueryBuilderProtoUtils {
    private MatchPhraseQueryBuilderProtoUtils() {
    }

    static MatchPhraseQueryBuilder fromProto(MatchPhraseQuery matchPhraseQueryProto) {
        ZeroTermsQuery zeroTermsQueryProto;
        MatchQuery.ZeroTermsQuery parsedZeroTermsQuery;
        if (matchPhraseQueryProto == null) {
            throw new IllegalArgumentException("MatchPhraseQuery cannot be null");
        }
        String fieldName = matchPhraseQueryProto.getField();
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty for match phrase query");
        }
        String value = matchPhraseQueryProto.getQuery();
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Query value cannot be null or empty for match phrase query");
        }
        float boost = 1.0f;
        String analyzer = null;
        int slop = 0;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
        String queryName = null;
        if (matchPhraseQueryProto.hasAnalyzer()) {
            analyzer = matchPhraseQueryProto.getAnalyzer();
        }
        if (matchPhraseQueryProto.hasSlop()) {
            int slopValue = matchPhraseQueryProto.getSlop();
            if (slopValue < 0) {
                throw new IllegalArgumentException("No negative slop allowed.");
            }
            slop = slopValue;
        }
        if (matchPhraseQueryProto.hasZeroTermsQuery() && (parsedZeroTermsQuery = MatchPhraseQueryBuilderProtoUtils.parseZeroTermsQuery(zeroTermsQueryProto = matchPhraseQueryProto.getZeroTermsQuery())) != null) {
            zeroTermsQuery = parsedZeroTermsQuery;
        }
        if (matchPhraseQueryProto.hasBoost()) {
            boost = matchPhraseQueryProto.getBoost();
        }
        if (matchPhraseQueryProto.hasXName()) {
            queryName = matchPhraseQueryProto.getXName();
        }
        MatchPhraseQueryBuilder matchQuery = new MatchPhraseQueryBuilder(fieldName, (Object)value);
        matchQuery.analyzer(analyzer);
        matchQuery.slop(slop);
        matchQuery.zeroTermsQuery(zeroTermsQuery);
        matchQuery.queryName(queryName);
        matchQuery.boost(boost);
        return matchQuery;
    }

    private static MatchQuery.ZeroTermsQuery parseZeroTermsQuery(ZeroTermsQuery zeroTermsQueryProto) {
        if (zeroTermsQueryProto == null) {
            return null;
        }
        switch (zeroTermsQueryProto) {
            case ZERO_TERMS_QUERY_ALL: {
                return MatchQuery.ZeroTermsQuery.ALL;
            }
            case ZERO_TERMS_QUERY_NONE: {
                return MatchQuery.ZeroTermsQuery.NONE;
            }
        }
        return null;
    }
}

