/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.swing.IconUtils;
import mediathek.tool.ColorUtils;
import mediathek.tool.cellrenderer.CellRendererBaseWithStart;
import mediathek.tool.table.MVTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome6.FontAwesomeSolid;
import org.kordamp.ikonli.swing.FontIcon;

public class CellRendererFilme
extends CellRendererBaseWithStart {
    private static final Logger logger = LogManager.getLogger(CellRendererFilme.class);
    private static final DateTimeFormatter PARSER = DateTimeFormatter.ofPattern("H:mm[:ss]");
    private static final DateTimeFormatter SHORT = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter LONG = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final int SECONDS_VARIANCE = 10;
    private final FontIcon selectedStopIcon;
    private final FontIcon normalStopIcon;
    private final SeenHistoryController history = new SeenHistoryController();
    private final FontIcon selectedDownloadIcon;
    private final FontIcon normalDownloadIcon;
    private final FontIcon selectedPlayIcon;
    private final FontIcon normalPlayIcon;
    private final FontIcon selectedBookmarkIcon;
    private final FontIcon normalBookmarkIcon;
    private final FontIcon selectedBookmarkIconHighlighted;
    private final List<Color> bgList = new ArrayList<Color>();

    public CellRendererFilme() {
        this.selectedDownloadIcon = FontIcon.of((Ikon)FontAwesomeSolid.DOWNLOAD, (int)16, (Color)Color.WHITE);
        this.normalDownloadIcon = IconUtils.of((Ikon)FontAwesomeSolid.DOWNLOAD);
        this.selectedPlayIcon = FontIcon.of((Ikon)FontAwesomeSolid.PLAY, (int)16, (Color)Color.WHITE);
        this.normalPlayIcon = IconUtils.of((Ikon)FontAwesomeSolid.PLAY);
        this.selectedStopIcon = FontIcon.of((Ikon)FontAwesomeSolid.STOP, (int)16, (Color)Color.WHITE);
        this.normalStopIcon = IconUtils.of((Ikon)FontAwesomeSolid.STOP);
        this.selectedBookmarkIcon = FontIcon.of((Ikon)FontAwesomeSolid.BOOKMARK, (int)16, (Color)Color.WHITE);
        this.selectedBookmarkIconHighlighted = FontIcon.of((Ikon)FontAwesomeSolid.BOOKMARK, (int)16, (Color)Color.ORANGE);
        this.normalBookmarkIcon = IconUtils.of((Ikon)FontAwesomeSolid.BOOKMARK);
    }

    private JTextArea createTextArea(String content) {
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setText(content);
        textArea.setForeground(this.getForeground());
        textArea.setBackground(this.getBackground());
        float fontSize = textArea.getFont().getSize2D();
        Font labelFont = UIManager.getFont("Label.font");
        textArea.setFont(labelFont.deriveFont(fontSize));
        return textArea;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.resetComponent();
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int rowModelIndex = table.convertRowIndexToModel(row);
            int columnModelIndex = table.convertColumnIndexToModel(column);
            DatenFilm datenFilm = (DatenFilm)table.getModel().getValueAt(rowModelIndex, 16);
            DatenDownload datenDownload = Daten.getInstance().getListeDownloadsButton().getDownloadUrlFilm(datenFilm.getUrlNormalQuality());
            boolean isBookMarked = datenFilm.isBookmarked();
            MVTable mvTable = (MVTable)table;
            if (mvTable.isLineBreak()) {
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(1);
                switch (columnModelIndex) {
                    case 2: 
                    case 3: 
                    case 14: {
                        JTextArea textArea = this.createTextArea(value.toString());
                        this.applyColorSettings(textArea, datenFilm, isBookMarked, isSelected);
                        return textArea;
                    }
                }
            } else {
                this.applyHorizontalAlignment(columnModelIndex);
            }
            switch (columnModelIndex) {
                case 9: {
                    this.setText(datenFilm.getFilmLengthAsString());
                    break;
                }
                case 4: {
                    this.handleButtonStartColumn(datenDownload, isSelected);
                    break;
                }
                case 5: {
                    this.handleButtonDownloadColumn(isSelected);
                    break;
                }
                case 6: {
                    this.handleButtonBookmarkColumn(isBookMarked, isSelected, datenFilm.isLivestream());
                    break;
                }
                case 1: {
                    if (!mvTable.showSenderIcons()) break;
                    Dimension targetDim = this.getSenderCellDimension(table, row, columnModelIndex);
                    this.setSenderIcon(value.toString(), targetDim);
                    break;
                }
                case 3: {
                    this.setText(datenFilm.getTitle());
                    this.setIndicatorIcons(table, datenFilm, isSelected);
                    break;
                }
                case 13: {
                    this.drawGeolocationIcons(datenFilm, isSelected);
                    break;
                }
                case 8: {
                    this.drawTime(datenFilm);
                }
            }
            this.applyColorSettings(this, datenFilm, isBookMarked, isSelected);
        }
        catch (Exception ex) {
            logger.error("Fehler", (Throwable)ex);
        }
        return this;
    }

    private void drawTime(@NotNull DatenFilm film) {
        String zeit = film.getSendeZeit();
        if (zeit == null || zeit.isBlank()) {
            this.setText("");
            return;
        }
        try {
            LocalTime t = LocalTime.parse(zeit.trim(), PARSER);
            this.setText((t.getSecond() < 10 ? SHORT : LONG).format(t));
        }
        catch (DateTimeParseException ex) {
            this.setText(zeit.trim());
        }
    }

    private void applyHorizontalAlignment(int columnModelIndex) {
        switch (columnModelIndex) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.setHorizontalAlignment(0);
                break;
            }
            case 10: {
                this.setHorizontalAlignment(4);
            }
        }
    }

    private void applyColorSettings(Component c, @NotNull DatenFilm datenFilm, boolean isBookMarked, boolean isSelected) {
        this.bgList.clear();
        this.bgList.add(c.getBackground());
        if (this.history.hasBeenSeen(datenFilm)) {
            this.bgList.add(MVColor.FILM_HISTORY.color);
        }
        if (datenFilm.isNew() && !isSelected) {
            c.setForeground(MVColor.getNewColor());
        }
        if (isBookMarked) {
            this.bgList.add(MVColor.FILM_BOOKMARKED.color);
        }
        if (datenFilm.isDuplicate()) {
            this.bgList.add(MVColor.FILM_DUPLICATE.color);
        }
        if (this.bgList.size() >= 2) {
            c.setBackground(ColorUtils.blend(this.bgList.toArray(new Color[0])));
        } else {
            c.setBackground(this.bgList.getFirst());
        }
    }

    private void handleButtonStartColumn(DatenDownload datenDownload, boolean isSelected) {
        if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
            this.setIconAndToolTip(isSelected, (Icon)this.normalStopIcon, (Icon)this.selectedStopIcon, "Film stoppen");
        }
        if (this.getIcon() == null) {
            this.setIconAndToolTip(isSelected, (Icon)this.normalPlayIcon, (Icon)this.selectedPlayIcon, "Film abspielen");
        }
    }

    private void setIconAndToolTip(boolean isSelected, Icon normal, Icon selected, String text) {
        this.setToolTipText(text);
        this.setIcon(isSelected ? selected : normal);
    }

    private void handleButtonDownloadColumn(boolean isSelected) {
        this.setIconAndToolTip(isSelected, (Icon)this.normalDownloadIcon, (Icon)this.selectedDownloadIcon, "Film aufzeichnen");
    }

    private void handleButtonBookmarkColumn(boolean isBookMarked, boolean isSelected, boolean isLivestream) {
        if (isLivestream) {
            this.setIcon(null);
            this.setToolTipText("");
        } else {
            this.setToolTipText(isBookMarked ? "Film aus Merkliste entfernen" : "Film merken");
            if (isBookMarked) {
                if (isSelected) {
                    this.setIcon((Icon)this.selectedBookmarkIconHighlighted);
                } else {
                    this.setIcon((Icon)this.selectedBookmarkIconHighlighted);
                }
            } else if (isSelected) {
                this.setIcon((Icon)this.selectedBookmarkIcon);
            } else {
                this.setIcon((Icon)this.normalBookmarkIcon);
            }
        }
    }
}

