import { IrcBridge } from "./IrcBridge";
import { IrcServer } from "../irc/IrcServer";
export declare class PublicitySyncer {
    private ircBridge;
    private visibilityMap;
    private initModeQueue;
    constructor(ircBridge: IrcBridge);
    initModeForChannel(opts: {
        server: IrcServer;
        channel: string;
    }): Promise<void>;
    initModes(server: IrcServer): Promise<void>;
    /**
     * Returns the key used when calling `updateVisibilityMap` for updating an IRC channel
     * visibility mode (+s or -s).
     * @param {string} networkId
     * @param {string} channel
     * @returns {string}
     */
    private getIRCVisMapKey;
    /**
     * Update the visibility of a given channel
     *
     * @param isSecret Is the channel secret.
     * @param channel Channel name
     * @param server Server the channel is part of.
     * @returns If the channel publicity was synced.
     */
    updateVisibilityMap(channel: string, server: IrcServer, isSecret: boolean): Promise<boolean>;
    private solveVisibility;
}
