/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Scanner;
import org.libjpegturbo.turbojpeg.TJCompressor;

final class TJComp {
    static final String CLASS_NAME = new TJComp().getClass().getName();
    static final int DEFAULT_SUBSAMP = 2;
    static final int DEFAULT_QUALITY = 75;
    static final String[] SUBSAMP_NAME = new String[]{"444", "422", "420", "GRAY", "440", "411", "441"};

    private TJComp() {
    }

    static void usage() {
        System.out.println("\nUSAGE: java [Java options] " + CLASS_NAME + " [options] <Input image> <JPEG image>\n");
        System.out.println("The input image can be in Windows BMP or PBMPLUS (PPM/PGM) format.\n");
        System.out.println("GENERAL OPTIONS (CAN BE ABBREVIATED)");
        System.out.println("------------------------------------");
        System.out.println("-icc FILE");
        System.out.println("    Embed the ICC (International Color Consortium) color management profile");
        System.out.println("    from the specified file into the JPEG image");
        System.out.println("-lossless PSV[,Pt]");
        System.out.println("    Create a lossless JPEG image (implies -subsamp 444) using predictor");
        System.out.println("    selection value PSV (1-7) and optional point transform Pt (0 through");
        System.out.println("    {data precision} - 1)");
        System.out.println("-maxmemory N");
        System.out.println("    Memory limit (in megabytes) for intermediate buffers used with progressive");
        System.out.println("    JPEG compression, lossless JPEG compression, and Huffman table optimization");
        System.out.println("    [default = no limit]");
        System.out.println("-precision N");
        System.out.println("    Create a JPEG image with N-bit data precision [N = 2..16; default = 8; if N");
        System.out.println("    is not 8 or 12, then -lossless must also be specified] (-precision 12");
        System.out.println("    implies -optimize unless -arithmetic is also specified)");
        System.out.println("-restart N");
        System.out.println("    Add a restart marker every N MCU rows [default = 0 (no restart markers)].");
        System.out.println("    Append 'B' to specify the restart marker interval in MCUs (lossy only.)\n");
        System.out.println("LOSSY JPEG OPTIONS (CAN BE ABBREVIATED)");
        System.out.println("---------------------------------------");
        System.out.println("-arithmetic");
        System.out.println("    Use arithmetic entropy coding instead of Huffman entropy coding (can be");
        System.out.println("    combined with -progressive)");
        System.out.println("-dct fast");
        System.out.println("    Use less accurate DCT algorithm [legacy feature]");
        System.out.println("-dct int");
        System.out.println("    Use more accurate DCT algorithm [default]");
        System.out.println("-grayscale");
        System.out.println("    Create a grayscale JPEG image from a full-color input image");
        System.out.println("-optimize");
        System.out.println("    Use Huffman table optimization");
        System.out.println("-progressive");
        System.out.println("    Create a progressive JPEG image instead of a single-scan JPEG image (can be");
        System.out.println("    combined with -arithmetic; implies -optimize unless -arithmetic is also");
        System.out.println("    specified)");
        System.out.println("-quality {1..100}");
        System.out.format("    Create a JPEG image with the specified quality level [default = %d]\n", 75);
        System.out.println("-rgb");
        System.out.println("    Create a JPEG image that uses the RGB colorspace instead of the YCbCr");
        System.out.println("    colorspace");
        System.out.println("-subsamp {444|422|440|420|411|441}");
        System.out.println("    Create a JPEG image that uses the specified chrominance subsampling level");
        System.out.format("    [default = %s]\n\n", SUBSAMP_NAME[2]);
        System.exit(1);
    }

    static boolean matchArg(String string, String string2, int n) {
        if (string.length() > string2.length() || string.length() < n) {
            return false;
        }
        int n2 = Math.max(string.length(), n);
        string2 = string2.substring(0, n2);
        return string.equalsIgnoreCase(string2);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        TJCompressor tJCompressor = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            int n11 = 8;
            int n12 = -1;
            int n13 = 75;
            int n14 = -1;
            int n15 = -1;
            int n16 = 2;
            String string = null;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (TJComp.matchArg(stringArray[n2], "-arithmetic", 2)) {
                    n3 = 1;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-dct", 2) && n2 < stringArray.length - 1) {
                    if (TJComp.matchArg(stringArray[++n2], "fast", 1)) {
                        n5 = 1;
                        continue;
                    }
                    if (TJComp.matchArg(stringArray[n2], "int", 1)) continue;
                    TJComp.usage();
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-grayscale", 2) || TJComp.matchArg(stringArray[n2], "-greyscale", 2)) {
                    n4 = 2;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-icc", 2) && n2 < stringArray.length - 1) {
                    string = stringArray[++n2];
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-lossless", 2) && n2 < stringArray.length - 1) {
                    Scanner scanner = new Scanner(stringArray[++n2]).useDelimiter(",");
                    try {
                        if (scanner.hasNextInt()) {
                            n6 = scanner.nextInt();
                        }
                        if (scanner.hasNextInt()) {
                            n7 = scanner.nextInt();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n6 >= 1 && n6 <= 7) continue;
                    TJComp.usage();
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-maxmemory", 2) && n2 < stringArray.length - 1) {
                    int n17 = -1;
                    try {
                        n17 = Integer.parseInt(stringArray[++n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n17 < 0) {
                        TJComp.usage();
                    }
                    n8 = n17;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-optimize", 2) || TJComp.matchArg(stringArray[n2], "-optimise", 2)) {
                    n9 = 1;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-precision", 4) && n2 < stringArray.length - 1) {
                    int n18 = 0;
                    try {
                        n18 = Integer.parseInt(stringArray[++n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n18 < 2 || n18 > 16) {
                        TJComp.usage();
                    }
                    n11 = n18;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-progressive", 2)) {
                    n12 = 1;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-quality", 2) && n2 < stringArray.length - 1) {
                    int n19 = 0;
                    try {
                        n19 = Integer.parseInt(stringArray[++n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n19 < 1 || n19 > 100) {
                        TJComp.usage();
                    }
                    n13 = n19;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-rgb", 3)) {
                    n4 = 0;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "-restart", 2) && n2 < stringArray.length - 1) {
                    int n20 = -1;
                    String string2 = stringArray[++n2];
                    Scanner scanner = new Scanner(string2).useDelimiter("b|B");
                    try {
                        n20 = scanner.nextInt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n20 < 0 || n20 > 65535 || scanner.hasNext()) {
                        TJComp.usage();
                    }
                    if (string2.endsWith("B") || string2.endsWith("b")) {
                        n14 = n20;
                        continue;
                    }
                    n15 = n20;
                    continue;
                }
                if (!TJComp.matchArg(stringArray[n2], "-subsamp", 2) || n2 >= stringArray.length - 1) break;
                if (TJComp.matchArg(stringArray[++n2], "444", 3)) {
                    n16 = 0;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "422", 3)) {
                    n16 = 1;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "440", 3)) {
                    n16 = 4;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "420", 3)) {
                    n16 = 2;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "411", 3)) {
                    n16 = 5;
                    continue;
                }
                if (TJComp.matchArg(stringArray[n2], "441", 3)) {
                    n16 = 6;
                    continue;
                }
                TJComp.usage();
            }
            if (n2 != stringArray.length - 2) {
                TJComp.usage();
            }
            if (n6 == -1 && n11 != 8 && n11 != 12) {
                TJComp.usage();
            }
            tJCompressor = new TJCompressor();
            tJCompressor.set(3, n13);
            tJCompressor.set(4, n16);
            tJCompressor.set(7, n11);
            if (n5 >= 0) {
                tJCompressor.set(10, n5);
            }
            if (n9 >= 0) {
                tJCompressor.set(11, n9);
            }
            if (n12 >= 0) {
                tJCompressor.set(12, n12);
            }
            if (n3 >= 0) {
                tJCompressor.set(14, n3);
            }
            if (n6 >= 1 && n6 <= 7) {
                tJCompressor.set(15, 1);
                tJCompressor.set(16, n6);
                if (n7 >= 0) {
                    tJCompressor.set(17, n7);
                }
            }
            if (n14 >= 0) {
                tJCompressor.set(18, n14);
            }
            if (n15 >= 0) {
                tJCompressor.set(19, n15);
            }
            if (n8 >= 0) {
                tJCompressor.set(23, n8);
            }
            tJCompressor.loadSourceImage(stringArray[n2], 1, n10);
            n10 = tJCompressor.getPixelFormat();
            if (n10 == 6 && n4 < 0) {
                n4 = 2;
            }
            if (n4 >= 0) {
                tJCompressor.set(8, n4);
            }
            if (string != null) {
                File file = new File(string);
                fileInputStream = new FileInputStream(file);
                int n21 = fileInputStream.available();
                if (n21 < 1) {
                    throw new Exception("ICC profile contains no data");
                }
                byte[] byArray = new byte[n21];
                fileInputStream.read(byArray);
                fileInputStream.close();
                fileInputStream = null;
                tJCompressor.setICCProfile(byArray);
            }
            byte[] byArray = tJCompressor.compress();
            File file = new File(stringArray[++n2]);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, tJCompressor.getCompressedSize());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (tJCompressor != null) {
                tJCompressor.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(n);
    }
}

