/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.Objects;

public class Limit {
    public static final Limit NONE = new Limit();
    private Integer firstRow;
    private Integer maxRows;

    public Limit() {
    }

    public Limit(Integer firstRow, Integer maxRows) {
        this.firstRow = firstRow;
        this.maxRows = maxRows;
    }

    public boolean isEmpty() {
        return this.firstRow == null && this.maxRows == null;
    }

    public Limit makeCopy() {
        return new Limit(this.firstRow, this.maxRows);
    }

    public Integer getFirstRow() {
        return this.firstRow;
    }

    public int getFirstRowJpa() {
        return this.firstRow == null ? 0 : this.firstRow;
    }

    public void setFirstRow(Integer firstRow) {
        this.firstRow = firstRow;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public int getMaxRowsJpa() {
        return this.maxRows == null ? Integer.MAX_VALUE : this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows < 0 ? null : Integer.valueOf(maxRows);
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows != null && maxRows < 0 ? null : maxRows;
    }

    public boolean isCompatible(Limit limit) {
        if (limit == null) {
            return this.isEmpty();
        }
        if (this == limit) {
            return true;
        }
        return Objects.equals(this.firstRow, limit.firstRow) && Objects.equals(this.maxRows, limit.maxRows);
    }
}

