/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import java.util.Objects;

public class EndpointConfig {
    private final String path;
    private final String verb;
    private final String consumes;
    private final String produces;
    private final String exposingMethod;

    public EndpointConfig(String path, String verb, String consumes, String produces, String exposingMethod) {
        this.path = path;
        this.verb = verb;
        this.consumes = consumes != null ? consumes : "*";
        this.produces = produces != null ? produces : "*";
        this.exposingMethod = exposingMethod;
    }

    public String toString() {
        return String.format("consumes %s, produces %s", this.consumes, this.produces);
    }

    public String toCompleteString() {
        return String.format("%s consumes %s, produces %s", this.exposingMethod, this.consumes, this.produces);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointConfig that = (EndpointConfig)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.verb, that.verb) && Objects.equals(this.consumes, that.consumes) && Objects.equals(this.produces, that.produces) && Objects.equals(this.exposingMethod, that.exposingMethod);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.verb, this.consumes, this.produces, this.exposingMethod);
    }

    public String getExposedEndpoint() {
        return String.format("%s %s", this.verb, this.path);
    }
}

