/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.RdfResource;
import java.util.Iterator;
import java.util.NoSuchElementException;

class Permutator
implements Iterator<RdfResource[]> {
    private final RdfResource[] array;
    private final short[] count;
    private boolean nextExists = true;
    private int state = 0;

    Permutator(RdfResource[] input) {
        this.array = (RdfResource[])input.clone();
        this.count = new short[this.array.length];
    }

    @Override
    public boolean hasNext() {
        return this.nextExists;
    }

    @Override
    public RdfResource[] next() {
        if (!this.nextExists) {
            throw new NoSuchElementException();
        }
        RdfResource[] output = (RdfResource[])this.array.clone();
        while (this.state < this.array.length) {
            if (this.count[this.state] < this.state) {
                if ((this.state & 1) == 0) {
                    this.swap(0, this.state);
                } else {
                    this.swap(this.count[this.state], this.state);
                }
                int n = this.state;
                this.count[n] = (short)(this.count[n] + 1);
                this.state = 0;
                return output;
            }
            this.count[this.state] = 0;
            ++this.state;
        }
        this.nextExists = false;
        return output;
    }

    private void swap(int i, int j) {
        RdfResource t = this.array[i];
        this.array[i] = this.array[j];
        this.array[j] = t;
    }
}

