/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal;

import com.webauthn4j.verifier.exception.NotAllowedCredentialIdException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CredentialIdVerifier {
    private CredentialIdVerifier() {
    }

    public static void verify(byte[] credentialId, @Nullable List<byte[]> allowCredentials) {
        if (allowCredentials != null && allowCredentials.stream().noneMatch(item -> Arrays.equals(item, credentialId))) {
            throw new NotAllowedCredentialIdException("credentialId not listed in allowCredentials is used.");
        }
    }
}

