/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextField;

public class XTextFieldEditor
extends XTextField
implements TableCellEditor {
    protected EventListenerList evtListenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    private FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    };

    public XTextFieldEditor() {
        this.textField.addFocusListener(this.editorFocusListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() instanceof JMenuItem || actionEvent.getSource() instanceof JTextField) {
            this.fireEditingStopped();
        }
    }

    protected void dropSuccess() {
        this.fireEditingStopped();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.evtListenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.evtListenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.evtListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.evtListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        Object object = this.getValue();
        if (object instanceof XObject) {
            return ((XObject)object).getObject();
        }
        return object;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string;
        if (jTable instanceof XTable) {
            XTable xTable = (XTable)jTable;
            string = xTable.getClassName(n);
        } else {
            string = String.class.getName();
        }
        try {
            this.init(object, Utils.getClass(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

