/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.info.Info;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010#\u001a\u00020\u001aH\u0016J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "Lcom/intellij/openapi/vcs/VcsMappingListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myLock", "", "myRootMapping", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/svn/WorkingCopy;", "myUnversioned", "", "myQueue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "myZipperUpdater", "Lcom/intellij/openapi/util/ZipperUpdater;", "myRechecker", "Ljava/lang/Runnable;", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "getVcs", "()Lorg/jetbrains/idea/svn/SvnVcs;", "addRoot", "", "root", "getMatchingCopy", "url", "Lorg/jetbrains/idea/svn/api/Url;", "getWcRoot", "calculateRoot", "registerWorkingCopy", "resolvedWorkingCopy", "dispose", "clear", "clearData", "directoryMappingChanged", "Companion", "intellij.vcs.svn"})
public final class RootsToWorkingCopies
implements VcsMappingListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Map<VirtualFile, WorkingCopy> myRootMapping;
    @NotNull
    private final Set<VirtualFile> myUnversioned;
    @NotNull
    private final BackgroundTaskQueue myQueue;
    @NotNull
    private final ZipperUpdater myZipperUpdater;
    @NotNull
    private final Runnable myRechecker;

    public RootsToWorkingCopies(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myLock = new Object();
        this.myRootMapping = new LinkedHashMap();
        this.myUnversioned = new LinkedHashSet();
        this.myQueue = new BackgroundTaskQueue(this.project, SvnBundle.message("progress.title.svn.roots.authorization.checker", new Object[0]));
        this.myZipperUpdater = new ZipperUpdater(200, (Disposable)this);
        this.myRechecker = () -> RootsToWorkingCopies.myRechecker$lambda$0(this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    private final SvnVcs getVcs() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)svnVcs), (String)"getInstance(...)");
        return svnVcs;
    }

    private final void addRoot(VirtualFile root) {
        Project project = this.project;
        Object[] objectArray = new Object[]{root.getPath()};
        String string = SvnBundle.message("progress.title.looking.for.file.working.copy.root", objectArray);
        this.myQueue.run(new Task.Backgroundable(this, root, project, string){
            final /* synthetic */ RootsToWorkingCopies this$0;
            final /* synthetic */ VirtualFile $root;
            {
                this.this$0 = $receiver;
                this.$root = $root;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RootsToWorkingCopies.access$calculateRoot(this.this$0, this.$root);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @Nullable
    public final WorkingCopy getMatchingCopy(@Nullable Url url) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (url == null) {
            return null;
        }
        Object[] roots = ProjectLevelVcsManager.getInstance((Project)this.project).getRootsUnderVcs((AbstractVcs)this.getVcs());
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])roots);
            while (iterator.hasNext()) {
                VirtualFile root = (VirtualFile)iterator.next();
                Intrinsics.checkNotNull((Object)root);
                WorkingCopy wcRoot = this.getWcRoot(root);
                if (wcRoot == null || !SvnUtil.isAncestor(wcRoot.getUrl(), url) && !SvnUtil.isAncestor(url, wcRoot.getUrl())) continue;
                WorkingCopy workingCopy = wcRoot;
                return workingCopy;
            }
            Unit unit = Unit.INSTANCE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @Nullable
    public final WorkingCopy getWcRoot(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            block6: {
                WorkingCopy existing;
                block5: {
                    boolean bl = false;
                    if (!this.myUnversioned.contains(root)) break block5;
                    WorkingCopy workingCopy = null;
                    return workingCopy;
                }
                WorkingCopy workingCopy = existing = this.myRootMapping.get(root);
                if (workingCopy == null) break block6;
                WorkingCopy workingCopy2 = workingCopy;
                return workingCopy2;
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.calculateRoot(root);
    }

    private final WorkingCopy calculateRoot(VirtualFile root) {
        Info svnInfo;
        File workingCopyRoot = SvnUtil.getWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        WorkingCopy workingCopy = null;
        if (workingCopyRoot != null && (svnInfo = this.getVcs().getInfo(workingCopyRoot)) != null && svnInfo.getUrl() != null) {
            workingCopy = new WorkingCopy(workingCopyRoot, svnInfo.getUrl());
        }
        return this.registerWorkingCopy(root, workingCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WorkingCopy registerWorkingCopy(VirtualFile root, WorkingCopy resolvedWorkingCopy) {
        Object object = this.myLock;
        synchronized (object) {
            Boolean bl;
            boolean bl2 = false;
            if (resolvedWorkingCopy == null) {
                this.myRootMapping.remove(root);
                bl = this.myUnversioned.add(root);
            } else {
                this.myUnversioned.remove(root);
                this.myRootMapping.put(root, resolvedWorkingCopy);
                bl = Unit.INSTANCE;
            }
            Boolean bl3 = bl;
        }
        return resolvedWorkingCopy;
    }

    public void dispose() {
        this.clearData();
    }

    public final void clear() {
        this.clearData();
        this.myZipperUpdater.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearData() {
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            this.myRootMapping.clear();
            this.myUnversioned.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void directoryMappingChanged() {
        SvnAuthenticationNotifier.Companion.getInstance(this.project).clear();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myRechecker.run();
        } else {
            this.myZipperUpdater.queue(this.myRechecker);
        }
    }

    private static final void myRechecker$lambda$0(RootsToWorkingCopies this$0) {
        this$0.clear();
        Object[] roots = ProjectLevelVcsManager.getInstance((Project)this$0.project).getRootsUnderVcs((AbstractVcs)this$0.getVcs());
        Iterator iterator = ArrayIteratorKt.iterator((Object[])roots);
        while (iterator.hasNext()) {
            VirtualFile root = (VirtualFile)iterator.next();
            Intrinsics.checkNotNull((Object)root);
            this$0.addRoot(root);
        }
    }

    @JvmStatic
    @NotNull
    public static final RootsToWorkingCopies getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ WorkingCopy access$calculateRoot(RootsToWorkingCopies $this, VirtualFile root) {
        return $this.calculateRoot(root);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/svn/RootsToWorkingCopies$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nRootsToWorkingCopies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootsToWorkingCopies.kt\norg/jetbrains/idea/svn/RootsToWorkingCopies$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,143:1\n30#2,2:144\n*S KotlinDebug\n*F\n+ 1 RootsToWorkingCopies.kt\norg/jetbrains/idea/svn/RootsToWorkingCopies$Companion\n*L\n140#1:144,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RootsToWorkingCopies getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RootsToWorkingCopies> serviceClass$iv = RootsToWorkingCopies.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RootsToWorkingCopies)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

