/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveTypeVarianceFix;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveTypeVarianceFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class RemoveTypeVarianceFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final RemoveTypeVarianceFixFactory INSTANCE = new RemoveTypeVarianceFixFactory();

    private RemoveTypeVarianceFixFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement().getParent();
        KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
        if (ktTypeReference == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)typeReference, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor descriptor2 = typeParameterDescriptor;
        Variance variance = descriptor2.getVariance();
        Intrinsics.checkNotNullExpressionValue((Object)variance, (String)"getVariance(...)");
        Variance variance2 = variance;
        if (variance2 == Variance.INVARIANT) {
            return null;
        }
        PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
        KtTypeParameter ktTypeParameter = psiElement2 instanceof KtTypeParameter ? (KtTypeParameter)psiElement2 : null;
        if (ktTypeParameter == null) {
            return null;
        }
        KtTypeParameter typeParameter = ktTypeParameter;
        return new RemoveTypeVarianceFix(typeParameter, variance2, IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2)).asIntention();
    }
}

