/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.storage;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public final class BuildTargetStorages
extends CompositeStorageOwner {
    private static final Logger LOG = Logger.getInstance(BuildTargetStorages.class);
    private final BuildTarget<?> myTarget;
    private final BuildDataPaths myPaths;
    private final ConcurrentMap<StorageProvider<? extends StorageOwner>, StorageOwner> myStorages;

    public BuildTargetStorages(@NotNull BuildTarget<?> target, @NotNull BuildDataPaths paths) {
        if (target == null) {
            BuildTargetStorages.$$$reportNull$$$0(0);
        }
        if (paths == null) {
            BuildTargetStorages.$$$reportNull$$$0(1);
        }
        this.myStorages = new ConcurrentHashMap<StorageProvider<? extends StorageOwner>, StorageOwner>();
        this.myTarget = target;
        this.myPaths = paths;
    }

    @NotNull
    public <S extends StorageOwner> S getOrCreateStorage(@NotNull StorageProvider<S> provider, PathRelativizerService relativizer) throws IOException {
        StorageOwner storageOwner;
        if (provider == null) {
            BuildTargetStorages.$$$reportNull$$$0(2);
        }
        try {
            storageOwner = this.myStorages.computeIfAbsent(provider, _provider -> {
                try {
                    return _provider.createStorage(this.myPaths.getTargetDataRootDir(this.myTarget), relativizer);
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            });
        }
        catch (BuildDataCorruptedException e) {
            LOG.info((Throwable)e);
            throw e.getCause();
        }
        if (storageOwner == null) {
            BuildTargetStorages.$$$reportNull$$$0(3);
        }
        return (S)storageOwner;
    }

    public void close(@NotNull StorageProvider<? extends StorageOwner> provider) throws IOException {
        StorageOwner storage;
        if (provider == null) {
            BuildTargetStorages.$$$reportNull$$$0(4);
        }
        if ((storage = (StorageOwner)this.myStorages.remove(provider)) != null) {
            storage.close();
        }
    }

    protected Iterable<StorageOwner> getChildStorages() {
        return () -> this.myStorages.values().iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/impl/storage/BuildTargetStorages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/impl/storage/BuildTargetStorages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateStorage";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

