/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertJavadocInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    private static final String TESTNG_PREFIX = "testng.";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "ConvertJavadoc";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConvertJavadocInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitDocTag(@NotNull PsiDocTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (tag.getName().startsWith(ConvertJavadocInspection.TESTNG_PREFIX)) {
                    holder.registerProblem((PsiElement)tag, TestngBundle.message("inspection.message.testng.javadoc.can.be.converted.to.annotations", new Object[0]), new LocalQuickFix[]{new ConvertJavadocQuickfix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$1", "visitDocTag"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection", "buildVisitor"));
    }

    private static class ConvertJavadocQuickfix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(ConvertJavadocQuickfix.class);

        private ConvertJavadocQuickfix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = TestngBundle.message("intention.family.name.convert.testng.javadoc.to.annotations", new Object[0]);
            if (string == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(1);
            }
            if (previewDescriptor == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(2);
            }
            PsiDocTag tag = (PsiDocTag)previewDescriptor.getPsiElement();
            ConvertJavadocQuickfix.doFix(project, tag);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocTag tag;
            if (project == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(5);
            }
            if (!TestNGUtil.checkTestNGInClasspath((PsiElement)(tag = (PsiDocTag)descriptor.getPsiElement()))) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{tag})) {
                return;
            }
            WriteAction.run(() -> ConvertJavadocQuickfix.doFix(project, tag));
        }

        private static void doFix(@NotNull Project project, PsiDocTag tag) {
            PsiMember member;
            if (project == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(6);
            }
            LOG.assertTrue((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiMember.class)) != null);
            @NonNls String annotationName = ConvertJavadocQuickfix.getFQAnnotationName(tag);
            StringBuilder annotationText = new StringBuilder("@");
            annotationText.append(annotationName);
            PsiClass annotationClass = (PsiClass)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)member.getProject()).findClass(annotationName, member.getResolveScope()));
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements.length > 1) {
                annotationText.append('(');
            }
            if (annotationClass != null) {
                for (PsiMethod attribute : annotationClass.getMethods()) {
                    boolean stripQuotes = false;
                    PsiType returnType = attribute.getReturnType();
                    if (returnType instanceof PsiPrimitiveType) {
                        stripQuotes = true;
                    }
                    for (int i = 0; i < dataElements.length; ++i) {
                        String next;
                        String key;
                        String text = dataElements[i].getText();
                        int equals = text.indexOf(61);
                        String string = key = equals == -1 ? text : text.substring(0, equals).trim();
                        if (!key.equals(attribute.getName())) continue;
                        annotationText.append(key).append(" = ");
                        String value = equals == -1 ? ((next = dataElements[++i].getText().trim()).length() == 1 ? dataElements[++i].getText().trim() : next.substring(1).trim()) : (equals < text.length() - 1 ? text.substring(equals + 1).trim() : dataElements[++i].getText().trim());
                        if (stripQuotes && value.charAt(0) == '\"') {
                            value = value.substring(1, value.length() - 1);
                        }
                        annotationText.append(value);
                    }
                }
            }
            if (dataElements.length > 1) {
                annotationText.append(')');
            }
            try {
                PsiModifierList modifierList = member.getModifierList();
                PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createAnnotationFromText(annotationText.toString(), (PsiElement)member);
                PsiElement inserted = modifierList.addBefore((PsiElement)annotation, modifierList.getFirstChild());
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(inserted);
                PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocComment.class);
                LOG.assertTrue(docComment != null);
                tag.delete();
                for (PsiElement element : docComment.getChildren()) {
                    if (element instanceof PsiWhiteSpace) continue;
                    if (!(element instanceof PsiDocToken)) {
                        return;
                    }
                    PsiDocToken docToken = (PsiDocToken)element;
                    if (docToken.getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA || docToken.getText().trim().isEmpty()) continue;
                    return;
                }
                docComment.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static String getFQAnnotationName(PsiDocTag tag) {
            @NonNls Object annotationName = StringUtil.capitalize((String)tag.getName().substring(ConvertJavadocInspection.TESTNG_PREFIX.length()));
            int dash = ((String)annotationName).indexOf(45);
            if (dash > -1) {
                annotationName = ((String)annotationName).substring(0, dash) + Character.toUpperCase(((String)annotationName).charAt(dash + 1)) + ((String)annotationName).substring(dash + 2);
            }
            annotationName = "org.testng.annotations." + (String)annotationName;
            return annotationName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

