/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class MethodInvoker {
    private static final ThreadLocal<List<Object>> keptValues = new ThreadLocal();

    public static Object invoke0(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[0]);
    }

    public static Object invoke1(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1});
    }

    public static Object invoke2(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2});
    }

    public static Object invoke3(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3});
    }

    public static Object invoke4(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static Object invoke5(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public static Object invoke6(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public static Object invoke7(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7});
    }

    public static Object invoke8(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
    }

    public static Object invoke9(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9});
    }

    public static Object invoke10(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10});
    }

    public static Object invoke(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, boolean vararg, Object[] args) throws Throwable {
        return MethodInvoker.invokeInternal(lookup, cls, obj, nameAndDescriptor, loader, args);
    }

    private static Object invokeInternal(MethodHandles.Lookup lookup, Class<?> cls, Object obj, String nameAndDescriptor, ClassLoader loader, Object[] args) throws Throwable {
        try {
            Object lastArg;
            int separatorIndex = nameAndDescriptor.indexOf(59);
            String name = nameAndDescriptor.substring(0, separatorIndex);
            String descriptor = nameAndDescriptor.substring(separatorIndex + 1);
            MethodType mt = MethodType.fromMethodDescriptorString(descriptor, loader);
            MethodHandle method = "<init>".equals(name) ? lookup.findConstructor(cls, mt) : (obj != null ? lookup.findVirtual(cls, name, mt) : lookup.findStatic(cls, name, mt));
            if (method == null) {
                throw new NoSuchMethodException(nameAndDescriptor + " not found in " + cls);
            }
            int parameterCount = mt.parameterCount();
            TypeDescriptor.OfField lastParameterType = parameterCount > 0 ? mt.parameterType(parameterCount - 1) : null;
            boolean vararg = method.isVarargsCollector();
            if (obj != null) {
                method = method.bindTo(obj);
                if (vararg) {
                    method = method.asVarargsCollector((Class<?>)lastParameterType);
                }
            }
            if (vararg && args.length == parameterCount && ((lastArg = args[args.length - 1]) == null || ((Class)lastParameterType).isAssignableFrom(lastArg.getClass()))) {
                method = method.asFixedArity();
            }
            Object result = method.invokeWithArguments(args);
            return MethodInvoker.keepReference(result, false);
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            e.printStackTrace();
            MethodInvoker.keepReference(e, true);
            throw e;
        }
        catch (Throwable e) {
            MethodInvoker.keepReference(e, true);
            throw e;
        }
    }

    private static Object keepReference(Object ref, boolean soft) {
        Object[] objectArray;
        if (ref == null) {
            return ref;
        }
        List<Object> objects = keptValues.get();
        if (objects == null) {
            objects = new LinkedList<Object>();
            keptValues.set(objects);
        }
        MethodInvoker.removeStaleReferences(objects);
        if (soft) {
            objectArray = new SoftReference(ref);
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ref;
        }
        Object[] wrapper = objectArray;
        objects.add(wrapper);
        return wrapper;
    }

    private static void removeStaleReferences(List<Object> objects) {
        Iterator<Object> iterator = objects.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Object[]) {
                if (((Object[])object)[0] != null) continue;
                iterator.remove();
                continue;
            }
            if (!(object instanceof SoftReference) || ((SoftReference)object).get() != null) continue;
            iterator.remove();
        }
    }
}

