/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ColorIdentifiers {
    private static final ColorIdentifiers singleton = new ColorIdentifiers();
    private final Map<String, String> colorKeywords = new HashMap<String, String>(147);
    private final HashSet<String> systemColors = new HashSet();

    private ColorIdentifiers() {
        this.colorKeywords.put("aliceblue", "#f0f8ff");
        this.colorKeywords.put("antiquewhite", "#faebd7");
        this.colorKeywords.put("aqua", "#0ff");
        this.colorKeywords.put("aquamarine", "#7fffd4");
        this.colorKeywords.put("azure", "#f0ffff");
        this.colorKeywords.put("beige", "#f5f5dc");
        this.colorKeywords.put("bisque", "#ffe4c4");
        this.colorKeywords.put("black", "#000");
        this.colorKeywords.put("blanchedalmond", "#ffebcd");
        this.colorKeywords.put("blue", "#00f");
        this.colorKeywords.put("blueviolet", "#8a2be2");
        this.colorKeywords.put("brown", "#a52a2a");
        this.colorKeywords.put("burlywood", "#deb887");
        this.colorKeywords.put("cadetblue", "#5f9ea0");
        this.colorKeywords.put("chartreuse", "#7fff00");
        this.colorKeywords.put("chocolate", "#d2691e");
        this.colorKeywords.put("coral", "#ff7f50");
        this.colorKeywords.put("cornflowerblue", "#6495ed");
        this.colorKeywords.put("cornsilk", "#fff8dc");
        this.colorKeywords.put("crimson", "#dc143c");
        this.colorKeywords.put("cyan", "#0ff");
        this.colorKeywords.put("darkblue", "#00008b");
        this.colorKeywords.put("darkcyan", "#008b8b");
        this.colorKeywords.put("darkgoldenrod", "#b8860b");
        this.colorKeywords.put("darkgray", "#a9a9a9");
        this.colorKeywords.put("darkgreen", "#006400");
        this.colorKeywords.put("darkgrey", "#a9a9a9");
        this.colorKeywords.put("darkkhaki", "#bdb76b");
        this.colorKeywords.put("darkmagenta", "#8b008b");
        this.colorKeywords.put("darkolivegreen", "#556b2f");
        this.colorKeywords.put("darkorange", "#ff8c00");
        this.colorKeywords.put("darkorchid", "#9932cc");
        this.colorKeywords.put("darkred", "#8b0000");
        this.colorKeywords.put("darksalmon", "#e9967a");
        this.colorKeywords.put("darkseagreen", "#8fbc8f");
        this.colorKeywords.put("darkslateblue", "#483d8b");
        this.colorKeywords.put("darkslategray", "#2f4f4f");
        this.colorKeywords.put("darkslategrey", "#2f4f4f");
        this.colorKeywords.put("darkturquoise", "#00ced1");
        this.colorKeywords.put("darkviolet", "#9400d3");
        this.colorKeywords.put("deeppink", "#ff1493");
        this.colorKeywords.put("deepskyblue", "#00bfff");
        this.colorKeywords.put("dimgray", "#696969");
        this.colorKeywords.put("dimgrey", "#696969");
        this.colorKeywords.put("dodgerblue", "#1e90ff");
        this.colorKeywords.put("firebrick", "#b22222");
        this.colorKeywords.put("floralwhite", "#fffaf0");
        this.colorKeywords.put("forestgreen", "#228b22");
        this.colorKeywords.put("fuchsia", "#f0f");
        this.colorKeywords.put("gainsboro", "#dcdcdc");
        this.colorKeywords.put("ghostwhite", "#f8f8ff");
        this.colorKeywords.put("gold", "#ffd700");
        this.colorKeywords.put("goldenrod", "#daa520");
        this.colorKeywords.put("gray", "#808080");
        this.colorKeywords.put("green", "#008000");
        this.colorKeywords.put("greenyellow", "#adff2f");
        this.colorKeywords.put("grey", "#808080");
        this.colorKeywords.put("honeydew", "#f0fff0");
        this.colorKeywords.put("hotpink", "#ff69b4");
        this.colorKeywords.put("indianred", "#cd5c5c");
        this.colorKeywords.put("indigo", "#4b0082");
        this.colorKeywords.put("ivory", "#fffff0");
        this.colorKeywords.put("khaki", "#f0e68c");
        this.colorKeywords.put("lavender", "#e6e6fa");
        this.colorKeywords.put("lavenderblush", "#fff0f5");
        this.colorKeywords.put("lawngreen", "#7cfc00");
        this.colorKeywords.put("lemonchiffon", "#fffacd");
        this.colorKeywords.put("lightblue", "#add8e6");
        this.colorKeywords.put("lightcoral", "#f08080");
        this.colorKeywords.put("lightcyan", "#e0ffff");
        this.colorKeywords.put("lightgoldenrodyellow", "#fafad2");
        this.colorKeywords.put("lightgray", "#d3d3d3");
        this.colorKeywords.put("lightgreen", "#90ee90");
        this.colorKeywords.put("lightgrey", "#d3d3d3");
        this.colorKeywords.put("lightpink", "#ffb6c1");
        this.colorKeywords.put("lightsalmon", "#ffa07a");
        this.colorKeywords.put("lightseagreen", "#20b2aa");
        this.colorKeywords.put("lightskyblue", "#87cefa");
        this.colorKeywords.put("lightslategray", "#778899");
        this.colorKeywords.put("lightslategrey", "#778899");
        this.colorKeywords.put("lightsteelblue", "#b0c4de");
        this.colorKeywords.put("lightyellow", "#ffffe0");
        this.colorKeywords.put("lime", "#0f0");
        this.colorKeywords.put("limegreen", "#32cd32");
        this.colorKeywords.put("linen", "#faf0e6");
        this.colorKeywords.put("magenta", "#f0f");
        this.colorKeywords.put("maroon", "#800000");
        this.colorKeywords.put("mediumaquamarine", "#66cdaa");
        this.colorKeywords.put("mediumblue", "#0000cd");
        this.colorKeywords.put("mediumorchid", "#ba55d3");
        this.colorKeywords.put("mediumpurple", "#9370db");
        this.colorKeywords.put("mediumseagreen", "#3cb371");
        this.colorKeywords.put("mediumslateblue", "#7b68ee");
        this.colorKeywords.put("mediumspringgreen", "#00fa9a");
        this.colorKeywords.put("mediumturquoise", "#48d1cc");
        this.colorKeywords.put("mediumvioletred", "#c71585");
        this.colorKeywords.put("midnightblue", "#191970");
        this.colorKeywords.put("mintcream", "#f5fffa");
        this.colorKeywords.put("mistyrose", "#ffe4e1");
        this.colorKeywords.put("moccasin", "#ffe4b5");
        this.colorKeywords.put("navajowhite", "#ffdead");
        this.colorKeywords.put("navy", "#000080");
        this.colorKeywords.put("oldlace", "#fdf5e6");
        this.colorKeywords.put("olive", "#808000");
        this.colorKeywords.put("olivedrab", "#6b8e23");
        this.colorKeywords.put("orange", "#ffa500");
        this.colorKeywords.put("orangered", "#ff4500");
        this.colorKeywords.put("orchid", "#da70d6");
        this.colorKeywords.put("palegoldenrod", "#eee8aa");
        this.colorKeywords.put("palegreen", "#98fb98");
        this.colorKeywords.put("paleturquoise", "#afeeee");
        this.colorKeywords.put("palevioletred", "#db7093");
        this.colorKeywords.put("papayawhip", "#ffefd5");
        this.colorKeywords.put("peachpuff", "#ffdab9");
        this.colorKeywords.put("peru", "#cd853f");
        this.colorKeywords.put("pink", "#ffc0cb");
        this.colorKeywords.put("plum", "#dda0dd");
        this.colorKeywords.put("powderblue", "#b0e0e6");
        this.colorKeywords.put("purple", "#800080");
        this.colorKeywords.put("rebeccapurple", "#663399");
        this.colorKeywords.put("red", "#f00");
        this.colorKeywords.put("rosybrown", "#bc8f8f");
        this.colorKeywords.put("royalblue", "#4169e1");
        this.colorKeywords.put("saddlebrown", "#8b4513");
        this.colorKeywords.put("salmon", "#fa8072");
        this.colorKeywords.put("sandybrown", "#f4a460");
        this.colorKeywords.put("seagreen", "#2e8b57");
        this.colorKeywords.put("seashell", "#fff5ee");
        this.colorKeywords.put("sienna", "#a0522d");
        this.colorKeywords.put("silver", "#c0c0c0");
        this.colorKeywords.put("skyblue", "#87ceeb");
        this.colorKeywords.put("slateblue", "#6a5acd");
        this.colorKeywords.put("slategray", "#708090");
        this.colorKeywords.put("slategrey", "#708090");
        this.colorKeywords.put("snow", "#fffafa");
        this.colorKeywords.put("springgreen", "#00ff7f");
        this.colorKeywords.put("steelblue", "#4682b4");
        this.colorKeywords.put("tan", "#d2b48c");
        this.colorKeywords.put("teal", "#008080");
        this.colorKeywords.put("thistle", "#d8bfd8");
        this.colorKeywords.put("tomato", "#ff6347");
        this.colorKeywords.put("turquoise", "#40e0d0");
        this.colorKeywords.put("violet", "#ee82ee");
        this.colorKeywords.put("wheat", "#f5deb3");
        this.colorKeywords.put("white", "#fff");
        this.colorKeywords.put("whitesmoke", "#f5f5f5");
        this.colorKeywords.put("yellow", "#ff0");
        this.colorKeywords.put("yellowgreen", "#9acd32");
        this.loadSystemColors();
    }

    private void loadSystemColors() {
        this.systemColors.add("activeborder");
        this.systemColors.add("activecaption");
        this.systemColors.add("appworkspace");
        this.systemColors.add("background");
        this.systemColors.add("buttonface");
        this.systemColors.add("buttonhighlight");
        this.systemColors.add("buttonshadow");
        this.systemColors.add("buttontext");
        this.systemColors.add("captiontext");
        this.systemColors.add("graytext");
        this.systemColors.add("highlight");
        this.systemColors.add("highlighttext");
        this.systemColors.add("inactiveborder");
        this.systemColors.add("inactivecaption");
        this.systemColors.add("inactivecaptiontext");
        this.systemColors.add("infobackground");
        this.systemColors.add("infotext");
        this.systemColors.add("menu");
        this.systemColors.add("menutext");
        this.systemColors.add("scrollbar");
        this.systemColors.add("threeddarkshadow");
        this.systemColors.add("threedface");
        this.systemColors.add("threedhighlight");
        this.systemColors.add("threedlightshadow");
        this.systemColors.add("threedshadow");
        this.systemColors.add("window");
        this.systemColors.add("windowframe");
        this.systemColors.add("windowtext");
    }

    public static ColorIdentifiers getInstance() {
        return singleton;
    }

    public String getColor(String keyword) {
        return this.colorKeywords.get(keyword);
    }

    public boolean isSystemColor(String identifier) {
        return this.systemColors.contains(identifier);
    }

    public boolean isColorIdentifier(String identifier) {
        return this.colorKeywords.containsKey(identifier) || this.systemColors.contains(identifier) || "transparent".equals(identifier) || "currentcolor".equals(identifier);
    }
}

