/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.OrderedShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;

abstract class ListOrderedShorthandBuilder
extends OrderedShorthandBuilder {
    ListOrderedShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue, String freeProperty) {
        super(shorthandName, parentStyle, initialvalue, freeProperty);
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        ValueList masterList;
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        StyleValue masterValue = this.getCSSValue(this.freeProperty);
        if (masterValue.getCssValueType() != CSSValue.CssType.LIST || !(masterList = (ValueList)masterValue).isCommaSeparated()) {
            return super.appendShorthandSet(buf, declaredSet, important);
        }
        int listLen = masterList.getLength();
        if (this.checkDeclaredValueListForInherit(declaredSet, listLen)) {
            return 1;
        }
        if (this.checkDeclaredValueListForKeyword(CSSValue.Type.REVERT, declaredSet, listLen)) {
            return 1;
        }
        if (this.isInheritedProperty() && this.checkDeclaredValueListForKeyword(CSSValue.Type.UNSET, declaredSet, listLen)) {
            return 1;
        }
        for (String property : declaredSet) {
            StyleValue value;
            CSSValue.CssType type;
            if (this.isResetProperty(property) || !((type = (value = this.getCSSValue(property)).getCssValueType()) == CSSValue.CssType.LIST ? this.invalidListValueClash(declaredSet, property, (ValueList)value) : this.invalidValueClash(declaredSet, property, value))) continue;
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        for (int index = 0; index < listLen; ++index) {
            String[] subp;
            if (index != 0) {
                buf.append(',');
            }
            boolean appended = false;
            for (String property : subp = this.getSubproperties()) {
                if (!declaredSet.contains(property)) continue;
                appended = this.appendValueText(index, buf, property, appended);
            }
            if (appended) continue;
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return 0;
    }

    private boolean checkDeclaredValueListForInherit(Set<String> declaredSet, int listLen) {
        for (String propertyName : declaredSet) {
            ValueList list = this.computeCSSItemList(propertyName, listLen - 1);
            for (int i = 0; i < listLen; ++i) {
                if (!this.isInherit(list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDeclaredValueListForKeyword(CSSValue.Type keyword, Set<String> declaredSet, int listLen) {
        for (String propertyName : declaredSet) {
            ValueList list = this.computeCSSItemList(propertyName, listLen - 1);
            for (int i = 0; i < listLen; ++i) {
                if (list.item(i).getPrimitiveType() != keyword) continue;
                return true;
            }
        }
        return false;
    }

    private boolean invalidListValueClash(Set<String> declaredSet, String property, ValueList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            if (!this.invalidValueClash(declaredSet, property, list.item(i))) continue;
            return true;
        }
        return false;
    }

    private boolean appendValueText(int index, StringBuilder buf, String property, boolean appended) {
        StyleValue cssVal = this.getCSSListItemValue(property, index);
        if (this.isNotInitialValue(cssVal, property) || !this.freeProperty.equals(property) && this.valueClash(index, property)) {
            if (appended) {
                buf.append(' ');
            }
            buf.append(cssVal.getMinifiedCssText(property));
            return true;
        }
        return appended;
    }

    StyleValue getCSSListItemValue(String propertyName, int index) {
        return this.computeCSSItemList(propertyName, index).item(index);
    }

    private ValueList computeCSSItemList(String propertyName, int lastIdx) {
        int items;
        ValueList list;
        StyleValue value = this.getCSSValue(propertyName);
        if (value.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)value).isCommaSeparated()) {
            list = (ValueList)value.clone();
            items = list.getLength();
        } else {
            list = ValueList.createCSValueList();
            list.add(value);
            value = list;
            items = 1;
        }
        if (lastIdx >= items) {
            int j = 0;
            while (items++ <= lastIdx) {
                list.add(list.item(j++));
            }
        }
        return list;
    }

    boolean isConflictingIdentifier(String property, CSSTypedValue freePrimi) {
        return freePrimi.getPrimitiveType() == CSSValue.Type.IDENT && ListOrderedShorthandBuilder.getShorthandDatabase().isIdentifierValue(property, freePrimi.getStringValue());
    }

    boolean listHasConflictingIdentifiers(String property, ValueList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            StyleValue item = list.item(i);
            CSSValue.CssType type = item.getCssValueType();
            if (type == CSSValue.CssType.TYPED) {
                if (!this.isConflictingIdentifier(property, (CSSTypedValue)((Object)item))) continue;
                return true;
            }
            if (type != CSSValue.CssType.LIST) continue;
            return this.listHasConflictingIdentifiers(property, (ValueList)item);
        }
        return false;
    }

    abstract boolean valueClash(int var1, String var2);
}

